"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimeout = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = require("react");

/*
 * Wire
 * Copyright (C) 2019 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
var useTimeout = function useTimeout(onTimeoutStop, duration) {
  var _useState = (0, _react.useState)(null),
      _useState2 = (0, _slicedToArray2["default"])(_useState, 2),
      timerId = _useState2[0],
      setTimerId = _useState2[1];

  var removeTimeout = function removeTimeout() {
    if (timerId) {
      window.clearTimeout(timerId);
      setTimerId(null);
    }
  };

  var start = function start() {
    removeTimeout();
    setTimerId(window.setTimeout(onStop, duration));
  };

  var onStop = function onStop() {
    removeTimeout();
    onTimeoutStop();
  };

  (0, _react.useEffect)(function () {
    return function () {
      removeTimeout();
    };
  }, [duration, onTimeoutStop]);
  return {
    removeTimeout: removeTimeout,
    startTimeout: start
  };
};

exports.useTimeout = useTimeout;
//# sourceMappingURL=useTimeout.js.map