"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Line = exports.lineStyle = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = require("@emotion/react");

var _react2 = _interopRequireDefault(require("react"));

var _Identity = require("../Identity");

var _sizes = require("../Layout/sizes");

/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */

/** @jsx jsx */
var lineStyle = function lineStyle(_ref) {
  var _ref$color = _ref.color,
      color = _ref$color === void 0 ? _Identity.COLOR.GRAY_LIGHTEN_72 : _ref$color;
  return {
    border: 'none',
    borderBottom: "1px solid ".concat(color),
    marginBottom: "".concat(_sizes.GUTTER, "px"),
    marginTop: "".concat(_sizes.GUTTER, "px")
  };
};

exports.lineStyle = lineStyle;

var Line = function Line(props) {
  return (0, _react.jsx)("hr", (0, _extends2["default"])({
    css: lineStyle(props)
  }, props));
};

exports.Line = Line;
//# sourceMappingURL=Line.js.map