/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.proxy;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.net.ssl.SSLException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.proxy.CacheProcessingItem;
import org.parosproxy.paros.core.proxy.ConnectRequestProxyListener;
import org.parosproxy.paros.core.proxy.CustomStreamsSocket;
import org.parosproxy.paros.core.proxy.OverrideMessageProxyListener;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.core.proxy.ProxyServer;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpInputStream;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpOutputStream;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.network.HttpUtil;
import org.parosproxy.paros.security.MissingRootCertificateException;
import org.zaproxy.zap.PersistentConnectionListener;
import org.zaproxy.zap.ZapGetMethod;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.network.HttpRequestBody;
import org.zaproxy.zap.network.HttpRequestConfig;
import org.zaproxy.zap.network.HttpResponseBody;

@Deprecated
public class ProxyThread
implements Runnable {
    private static final String CONNECT_HTTP_200 = "HTTP/1.1 200 Connection established\r\n\r\n";
    private static Logger log = LogManager.getLogger(ProxyThread.class);
    private static final String BAD_GATEWAY_RESPONSE_STATUS = "502 Bad Gateway";
    private static final String GATEWAY_TIMEOUT_RESPONSE_STATUS = "504 Gateway Timeout";
    private static final HttpRequestConfig EXCLUDED_REQ_CONFIG = HttpRequestConfig.builder().setNotifyListeners(false).build();
    protected ProxyServer parentServer = null;
    protected ProxyParam proxyParam = null;
    protected ConnectionParam connectionParam = null;
    protected Thread thread = null;
    protected Socket inSocket = null;
    protected Socket outSocket = null;
    protected HttpInputStream httpIn = null;
    protected HttpOutputStream httpOut = null;
    protected ProxyThread originProcess = this;
    private HttpSender httpSender = null;
    private Object semaphore = this;
    private boolean keepSocketOpen = false;
    private static Object semaphoreSingleton = new Object();
    private static int id = 1;
    private static Vector<Thread> proxyThreadList = new Vector();

    protected ProxyThread(ProxyServer server, Socket socket) {
        this(server, socket, null);
    }

    protected ProxyThread(ProxyServer server, Socket socket, HttpSender httpSender) {
        this.parentServer = server;
        this.proxyParam = this.parentServer.getProxyParam();
        this.connectionParam = this.parentServer.getConnectionParam();
        this.httpSender = httpSender;
        this.inSocket = socket;
        try {
            this.inSocket.setTcpNoDelay(true);
            this.inSocket.setSoTimeout(this.connectionParam.getTimeoutInSecs() * 1000);
        }
        catch (SocketException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        this.thread = new Thread((Runnable)this, "ZAP-ProxyThread-" + id++);
        this.thread.setDaemon(true);
        this.thread.setPriority(4);
    }

    public void start() {
        this.thread.start();
    }

    private void beginSSL(String targethost) throws IOException {
        try {
            this.inSocket = HttpSender.getSSLConnector().createTunnelServerSocket(targethost, this.inSocket);
        }
        catch (MissingRootCertificateException e) {
            throw new MissingRootCertificateException(e);
        }
        catch (Exception e) {
            StringBuilder strBuilder = new StringBuilder(125);
            strBuilder.append("Error while establishing SSL connection for ");
            if (targethost == null) {
                strBuilder.append("an unknown target domain (relying on SNI extension), cause: " + e.getMessage());
            } else {
                strBuilder.append("'" + targethost + "'!");
            }
            throw new IOException(strBuilder.toString(), e);
        }
        this.httpIn = new HttpInputStream(this.inSocket);
        this.httpOut = new HttpOutputStream(this.inSocket.getOutputStream());
    }

    private static boolean isSslTlsHandshake(BufferedInputStream inputStream) throws IOException {
        byte[] bytes = new byte[3];
        inputStream.mark(3);
        int bytesRead = inputStream.read(bytes);
        inputStream.reset();
        if (bytesRead == -1) {
            throw new IOException("Failed to check if SSL/TLS handshake, reached end of the stream.");
        }
        if (bytesRead < 3) {
            log.debug("Failed to check if SSL/TLS handshake, got just {} bytes: {}", (Object)bytesRead, (Object)Arrays.toString(bytes));
            return false;
        }
        return bytes[0] == 22 && (bytes[1] >= 3 || bytes[1] == 0 && bytes[2] == 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block21: {
            proxyThreadList.add(this.thread);
            boolean isSecure = false;
            HttpRequestHeader firstHeader = null;
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.inSocket.getInputStream(), 2048);
                this.inSocket = new CustomStreamsSocket(this.inSocket, bufferedInputStream, this.inSocket.getOutputStream());
                if (ProxyThread.isSslTlsHandshake(bufferedInputStream)) {
                    isSecure = true;
                    this.beginSSL(null);
                }
                this.httpIn = new HttpInputStream(this.inSocket);
                this.httpOut = new HttpOutputStream(this.inSocket.getOutputStream());
                firstHeader = this.httpIn.readRequestHeader(isSecure);
                firstHeader.setSenderAddress(this.inSocket.getInetAddress());
                if (firstHeader.getMethod().equalsIgnoreCase("CONNECT")) {
                    HttpMessage connectMsg = new HttpMessage(firstHeader);
                    connectMsg.setTimeSentMillis(System.currentTimeMillis());
                    try {
                        this.httpOut.write(CONNECT_HTTP_200);
                        this.httpOut.flush();
                        connectMsg.setResponseHeader(CONNECT_HTTP_200);
                        connectMsg.setTimeElapsedMillis((int)(System.currentTimeMillis() - connectMsg.getTimeSentMillis()));
                        this.notifyConnectMessage(connectMsg);
                        if (ProxyThread.isSslTlsHandshake(bufferedInputStream)) {
                            isSecure = true;
                            this.beginSSL(firstHeader.getHostName());
                        }
                        firstHeader = this.httpIn.readRequestHeader(isSecure);
                        firstHeader.setSenderAddress(this.inSocket.getInetAddress());
                        this.processHttp(firstHeader, isSecure);
                        break block21;
                    }
                    catch (MissingRootCertificateException e) {
                        HttpMessage errmsg = new HttpMessage(firstHeader);
                        this.setErrorResponse(errmsg, BAD_GATEWAY_RESPONSE_STATUS, e, "ZAP SSL Error");
                        ProxyThread.writeHttpResponse(errmsg, this.httpOut);
                        throw new IOException(e);
                    }
                }
                this.processHttp(firstHeader, isSecure);
            }
            catch (SocketTimeoutException e) {
                if (firstHeader != null) {
                    if ("CONNECT".equalsIgnoreCase(firstHeader.getMethod())) {
                        log.warn("Timeout reading (client) message after CONNECT to {}", (Object)firstHeader.getURI());
                    } else {
                        log.warn("Timeout accessing {}", (Object)firstHeader.getURI());
                    }
                } else {
                    log.warn("Socket timeout while reading first message.");
                    log.debug((Object)e, (Throwable)e);
                }
            }
            catch (HttpMalformedHeaderException e) {
                log.warn("Malformed Header: ", (Throwable)e);
            }
            catch (HttpException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                log.debug("IOException: ", (Throwable)e);
            }
            finally {
                proxyThreadList.remove(this.thread);
                if (!this.keepSocketOpen) {
                    this.disconnect();
                }
            }
        }
    }

    private void notifyConnectMessage(HttpMessage connectMessage) {
        for (ConnectRequestProxyListener listener : this.parentServer.getConnectRequestProxyListeners()) {
            try {
                listener.receivedConnectRequest(connectMessage);
            }
            catch (Exception e) {
                log.error("An error occurred while notifying listener:", (Throwable)e);
            }
        }
    }

    private void setErrorResponse(HttpMessage msg, String responseStatus, Exception cause) throws HttpMalformedHeaderException {
        this.setErrorResponse(msg, responseStatus, cause, "ZAP Error");
    }

    private void setErrorResponse(HttpMessage msg, String responseStatus, Exception cause, String errorType) throws HttpMalformedHeaderException {
        StringBuilder strBuilder = new StringBuilder();
        if (cause instanceof SSLException) {
            strBuilder.append(Constant.messages.getString("network.ssl.error.connect"));
            strBuilder.append(msg.getRequestHeader().getURI().toString()).append('\n');
            strBuilder.append(Constant.messages.getString("network.ssl.error.exception")).append(cause.getMessage()).append('\n');
            strBuilder.append(Constant.messages.getString("network.ssl.error.exception.rootcause")).append(ExceptionUtils.getRootCauseMessage((Throwable)cause)).append('\n');
            strBuilder.append(Constant.messages.getString("network.ssl.error.help", Constant.messages.getString("network.ssl.error.help.url")));
            log.warn(strBuilder.toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)cause, (Throwable)cause);
                strBuilder.append("\n\nStack Trace:\n");
                for (String stackTraceFrame : ExceptionUtils.getRootCauseStackTrace((Throwable)cause)) {
                    strBuilder.append(stackTraceFrame).append('\n');
                }
            }
        } else {
            strBuilder.append(errorType).append(" [").append(cause.getClass().getName()).append("]: ").append(cause.getLocalizedMessage()).append("\n");
            if (cause instanceof UnknownHostException && this.connectionParam.isUseProxyChain() && this.connectionParam.getProxyChainName().equalsIgnoreCase(cause.getMessage())) {
                strBuilder.append(Constant.messages.getString("conn.options.proxy.error.response.msg"));
            }
            strBuilder.append("\n\nStack Trace:\n");
            for (String stackTraceFrame : ExceptionUtils.getRootCauseStackTrace((Throwable)cause)) {
                strBuilder.append(stackTraceFrame).append('\n');
            }
        }
        ProxyThread.setErrorResponse(msg, responseStatus, strBuilder.toString());
    }

    private static void setErrorResponse(HttpMessage msg, String responseStatus, String message) throws HttpMalformedHeaderException {
        HttpResponseHeader responseHeader = new HttpResponseHeader("HTTP/1.1 " + responseStatus);
        responseHeader.setHeader("Content-Type", "text/plain; charset=UTF-8");
        responseHeader.setHeader("Content-Length", Integer.toString(message.getBytes(StandardCharsets.UTF_8).length));
        msg.setResponseHeader(responseHeader);
        if (!"HEAD".equals(msg.getRequestHeader().getMethod())) {
            msg.setResponseBody(message);
        }
    }

    private static void writeHttpResponse(HttpMessage msg, HttpOutputStream outputStream) throws IOException {
        outputStream.write(msg.getResponseHeader());
        outputStream.flush();
        if (msg.getResponseBody().length() > 0) {
            outputStream.write(msg.getResponseBody().getBytes());
            outputStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processHttp(HttpRequestHeader requestHeader, boolean isSecure) throws IOException {
        HttpRequestBody reqBody = null;
        boolean isFirstRequest = true;
        HttpMessage msg = null;
        this.inSocket.setSoTimeout(2500);
        do {
            if (isFirstRequest) {
                isFirstRequest = false;
            } else {
                try {
                    requestHeader = this.httpIn.readRequestHeader(isSecure);
                    requestHeader.setSenderAddress(this.inSocket.getInetAddress());
                }
                catch (SocketTimeoutException e) {
                    log.debug("Timed out while reading a new HTTP request.");
                    return;
                }
            }
            if (this.parentServer.isEnableApi() && (msg = API.getInstance().handleApiRequest(requestHeader, this.httpIn, this.httpOut, this.isRecursive(requestHeader))) != null) {
                if (msg.getRequestHeader().isEmpty()) {
                    return;
                }
                ZapGetMethod method = new ZapGetMethod();
                method.setUpgradedSocket(this.inSocket);
                method.setUpgradedInputStream(this.httpIn);
                this.keepSocketOpen = this.notifyPersistentConnectionListener(msg, this.inSocket, method);
                return;
            }
            msg = new HttpMessage();
            msg.setRequestHeader(requestHeader);
            if (msg.getRequestHeader().getContentLength() > 0) {
                reqBody = this.httpIn.readRequestBody(requestHeader);
                msg.setRequestBody(reqBody);
            }
            if (this.proxyParam.isRemoveUnsupportedEncodings()) {
                this.removeUnsupportedEncodings(msg);
            }
            if (this.isProcessCache(msg)) continue;
            this.semaphore = this.parentServer.isSerialize() ? semaphoreSingleton : this;
            boolean send = true;
            boolean excluded = this.parentServer.excludeUrl(msg.getRequestHeader().getURI());
            Object object = this.semaphore;
            synchronized (object) {
                block30: {
                    if (!excluded) {
                        if (this.notifyOverrideListenersRequestSend(msg)) {
                            send = false;
                        } else if (!this.notifyListenerRequestSend(msg)) {
                            return;
                        }
                    }
                    try {
                        if (excluded) {
                            this.getHttpSender().sendAndReceive(msg, EXCLUDED_REQ_CONFIG);
                        } else if (send) {
                            if (msg.getResponseHeader().isEmpty()) {
                                this.getHttpSender().sendAndReceive(msg);
                            }
                            if (this.proxyParam.isAlwaysDecodeGzip()) {
                                ProxyThread.decodeResponseIfNeeded(msg);
                            }
                            if (!this.notifyOverrideListenersResponseReceived(msg) && !this.notifyListenerResponseReceive(msg)) {
                                return;
                            }
                        }
                    }
                    catch (HttpException e) {
                        throw e;
                    }
                    catch (SocketTimeoutException e) {
                        String message = Constant.messages.getString("proxy.error.readtimeout", msg.getRequestHeader().getURI(), this.connectionParam.getTimeoutInSecs());
                        log.warn(message);
                        ProxyThread.setErrorResponse(msg, GATEWAY_TIMEOUT_RESPONSE_STATUS, message);
                        if (!excluded) {
                            this.notifyListenerResponseReceive(msg);
                        }
                    }
                    catch (IOException e) {
                        this.setErrorResponse(msg, BAD_GATEWAY_RESPONSE_STATUS, e);
                        if (excluded) break block30;
                        this.notifyListenerResponseReceive(msg);
                    }
                }
                try {
                    ProxyThread.writeHttpResponse(msg, this.httpOut);
                }
                catch (IOException e) {
                    StringBuilder strBuilder = new StringBuilder(200);
                    strBuilder.append("Failed to write/forward the HTTP response to the client: ");
                    strBuilder.append(e.getClass().getName());
                    if (e.getMessage() != null) {
                        strBuilder.append(": ").append(e.getMessage());
                    }
                    log.warn(strBuilder.toString());
                }
            }
            ZapGetMethod method = (ZapGetMethod)((Object)msg.getUserObject());
            this.keepSocketOpen = this.notifyPersistentConnectionListener(msg, this.inSocket, method);
            if (this.keepSocketOpen) break;
        } while (!this.isConnectionClose(msg) && !this.inSocket.isClosed());
    }

    static void decodeResponseIfNeeded(HttpMessage msg) {
        HttpResponseBody body = msg.getResponseBody();
        if (body.getContentEncodings().isEmpty() || body.hasContentEncodingErrors()) {
            return;
        }
        body.setBody(body.getContent());
        body.setContentEncodings(Collections.emptyList());
        HttpResponseHeader header = msg.getResponseHeader();
        header.setHeader("Content-Encoding", null);
        if (header.getHeader("Content-Length") != null) {
            header.setContentLength(body.length());
        }
    }

    private boolean isConnectionClose(HttpMessage msg) {
        if (msg == null || msg.getResponseHeader().isEmpty()) {
            return true;
        }
        if (msg.getRequestHeader().isConnectionClose()) {
            return true;
        }
        if (msg.getResponseHeader().isConnectionClose()) {
            return true;
        }
        return msg.getResponseHeader().getContentLength() == -1 && msg.getResponseBody().length() > 0;
    }

    protected void disconnect() {
        try {
            if (this.httpIn != null) {
                this.httpIn.close();
            }
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        try {
            if (this.httpOut != null) {
                this.httpOut.close();
            }
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        HttpUtil.closeSocket(this.inSocket);
        if (this.httpSender != null) {
            this.httpSender.shutdown();
        }
    }

    private boolean notifyListenerRequestSend(HttpMessage httpMessage) {
        ProxyListener listener = null;
        List<ProxyListener> listenerList = this.parentServer.getListenerList();
        for (int i = 0; i < listenerList.size(); ++i) {
            listener = listenerList.get(i);
            try {
                if (listener.onHttpRequestSend(httpMessage)) continue;
                return false;
            }
            catch (Exception e) {
                log.error("An error occurred while notifying listener:", (Throwable)e);
            }
        }
        return true;
    }

    private boolean notifyListenerResponseReceive(HttpMessage httpMessage) {
        ProxyListener listener = null;
        List<ProxyListener> listenerList = this.parentServer.getListenerList();
        for (int i = 0; i < listenerList.size(); ++i) {
            listener = listenerList.get(i);
            try {
                if (listener.onHttpResponseReceive(httpMessage)) continue;
                return false;
            }
            catch (Exception e) {
                log.error("An error occurred while notifying listener:", (Throwable)e);
            }
        }
        return true;
    }

    private boolean notifyOverrideListenersRequestSend(HttpMessage httpMessage) {
        for (OverrideMessageProxyListener listener : this.parentServer.getOverrideMessageProxyListeners()) {
            try {
                if (!listener.onHttpRequestSend(httpMessage)) continue;
                return true;
            }
            catch (Exception e) {
                log.error("An error occurred while notifying listener:", (Throwable)e);
            }
        }
        return false;
    }

    private boolean notifyOverrideListenersResponseReceived(HttpMessage httpMessage) {
        for (OverrideMessageProxyListener listener : this.parentServer.getOverrideMessageProxyListeners()) {
            try {
                if (!listener.onHttpResponseReceived(httpMessage)) continue;
                return true;
            }
            catch (Exception e) {
                log.error("An error occurred while notifying listener:", (Throwable)e);
            }
        }
        return false;
    }

    private boolean notifyPersistentConnectionListener(HttpMessage httpMessage, Socket inSocket, ZapGetMethod method) {
        boolean keepSocketOpen = false;
        PersistentConnectionListener listener = null;
        List<PersistentConnectionListener> listenerList = this.parentServer.getPersistentConnectionListenerList();
        for (int i = 0; i < listenerList.size(); ++i) {
            listener = listenerList.get(i);
            try {
                if (!listener.onHandshakeResponse(httpMessage, inSocket, method)) continue;
                keepSocketOpen = true;
                break;
            }
            catch (Exception e) {
                log.error("An error occurred while notifying listener:", (Throwable)e);
            }
        }
        return keepSocketOpen;
    }

    private boolean isRecursive(HttpRequestHeader header) {
        try {
            if (header.getHostPort() == this.inSocket.getLocalPort()) {
                String targetDomain = header.getHostName();
                if ("zap".equals(targetDomain)) {
                    return true;
                }
                if (this.isProxyAddress(InetAddress.getByName(targetDomain))) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private boolean isProxyAddress(InetAddress address) {
        return this.parentServer.getProxyParam().isProxyIpAnyLocalAddress() ? ProxyThread.isLocalAddress(address) || ProxyThread.isNetworkInterfaceAddress(address) : address.equals(this.inSocket.getLocalAddress());
    }

    private static boolean isLocalAddress(InetAddress address) {
        return address.isLoopbackAddress() || address.isSiteLocalAddress() || address.isAnyLocalAddress();
    }

    private static boolean isNetworkInterfaceAddress(InetAddress address) {
        try {
            if (NetworkInterface.getByInetAddress(address) != null) {
                return true;
            }
        }
        catch (SocketException e) {
            log.warn("Failed to check if an address is from a network interface:", (Throwable)e);
        }
        return false;
    }

    private void removeUnsupportedEncodings(HttpMessage msg) {
        String encoding = msg.getRequestHeader().getHeader("Accept-Encoding");
        if (encoding == null) {
            return;
        }
        msg.getRequestHeader().setHeader("Accept-Encoding", null);
    }

    protected HttpSender getHttpSender() {
        if (this.httpSender == null) {
            this.httpSender = new HttpSender(this.connectionParam, true, 1);
        }
        return this.httpSender;
    }

    static boolean isAnyProxyThreadRunning() {
        return !proxyThreadList.isEmpty();
    }

    protected boolean isProcessCache(HttpMessage msg) throws IOException {
        if (!this.parentServer.isEnableCacheProcessing()) {
            return false;
        }
        if (this.parentServer.getCacheProcessingList().isEmpty()) {
            return false;
        }
        CacheProcessingItem item = this.parentServer.getCacheProcessingList().get(0);
        if (msg.equals(item.message)) {
            HttpMessage newMsg = item.message.cloneAll();
            msg.setResponseHeader(newMsg.getResponseHeader());
            msg.setResponseBody(newMsg.getResponseBody());
            ProxyThread.writeHttpResponse(msg, this.httpOut);
            return true;
        }
        try {
            RecordHistory history = Model.getSingleton().getDb().getTableHistory().getHistoryCache(item.reference, msg);
            if (history == null) {
                return false;
            }
            msg.setResponseHeader(history.getHttpMessage().getResponseHeader());
            msg.setResponseBody(history.getHttpMessage().getResponseBody());
            ProxyThread.writeHttpResponse(msg, this.httpOut);
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }
}

