/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import org.apache.commons.httpclient.URIException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.core.scanner.VariantAbstractQuery;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMessage;

public class VariantURLQuery
extends VariantAbstractQuery {
    private static final Logger LOG = LogManager.getLogger(VariantURLQuery.class);
    private static final String SHORT_NAME = "querystring";

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    protected String getEscapedValue(HttpMessage msg, String value) {
        return value != null ? AbstractPlugin.getURLEncode(value) : "";
    }

    @Override
    protected String getUnescapedValue(String value) {
        return value != null ? AbstractPlugin.getURLDecode(value) : "";
    }

    @Override
    public void setMessage(HttpMessage msg) {
        this.setParameters(1, Model.getSingleton().getSession().getParameters(msg, HtmlParameter.Type.url));
    }

    @Override
    protected void buildMessage(HttpMessage msg, String query) {
        try {
            msg.getRequestHeader().getURI().setEscapedQuery(query);
        }
        catch (URIException e) {
            LOG.error("{} {}", (Object)e.getMessage(), (Object)query, (Object)e);
        }
    }
}

