/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.InvalidRedirectLocationException;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthPolicy;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpMethodHelper;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.network.HttpSenderContextParos;
import org.parosproxy.paros.network.SSLConnector;
import org.zaproxy.zap.ZapGetMethod;
import org.zaproxy.zap.ZapHttpConnectionManager;
import org.zaproxy.zap.network.HttpRedirectionValidator;
import org.zaproxy.zap.network.HttpRequestConfig;
import org.zaproxy.zap.network.HttpSenderImpl;
import org.zaproxy.zap.network.HttpSenderListener;
import org.zaproxy.zap.network.ZapCookieSpec;
import org.zaproxy.zap.network.ZapNTLMScheme;
import org.zaproxy.zap.users.User;

@Deprecated
public class HttpSenderParos
implements HttpSenderImpl<HttpSenderContextParos> {
    private static final Logger log = LogManager.getLogger(HttpSenderParos.class);
    private static SSLConnector sslConnector;
    private static List<HttpSenderListener> listeners;
    private static final Comparator<HttpSenderListener> LISTENERS_COMPARATOR;
    private static HttpMethodHelper helper;
    private static final ThreadLocal<Boolean> IN_LISTENER;
    private static final HttpRequestConfig NO_REDIRECTS;
    private static final HttpRequestConfig FOLLOW_REDIRECTS;
    private static final ResponseBodyConsumer DEFAULT_BODY_CONSUMER;
    private ConnectionParam param = null;
    private static MultiThreadedHttpConnectionManager httpConnManager;

    private ConnectionParam getParam() {
        if (this.param == null) {
            this.param = Model.getSingleton().getOptionsParam().getConnectionParam();
        }
        return this.param;
    }

    @Override
    public boolean isGlobalStateEnabled() {
        return this.getParam().isHttpStateEnabled();
    }

    private static MultiThreadedHttpConnectionManager getConnectionManager() {
        if (httpConnManager == null) {
            HttpSenderParos.createConnectionManager();
        }
        return httpConnManager;
    }

    private static synchronized void createConnectionManager() {
        if (httpConnManager == null) {
            httpConnManager = new MultiThreadedHttpConnectionManager();
            httpConnManager.getParams().setStaleCheckingEnabled(true);
            httpConnManager.getParams().setDefaultMaxConnectionsPerHost(10000);
            httpConnManager.getParams().setMaxTotalConnections(200000);
        }
    }

    SSLConnector getSslConnector() {
        return sslConnector;
    }

    HttpClient getClient() {
        return new HttpClient((HttpConnectionManager)HttpSenderParos.getConnectionManager());
    }

    private void setProxyAuth(HttpState state) {
        if (this.getParam().isUseProxyChain() && this.getParam().isUseProxyChainAuth()) {
            String realm = this.getParam().getProxyChainRealm();
            state.setProxyCredentials(new AuthScope(this.getParam().getProxyChainName(), this.getParam().getProxyChainPort(), realm.isEmpty() ? AuthScope.ANY_REALM : realm), (Credentials)new NTCredentials(this.getParam().getProxyChainUserName(), this.getParam().getProxyChainPassword(), "", realm));
        } else {
            state.clearProxyCredentials();
        }
    }

    @Override
    public HttpSenderContextParos createContext(HttpSender parent, int initiator) {
        HttpClient client = new HttpClient((HttpConnectionManager)HttpSenderParos.getConnectionManager());
        client.getParams().setBooleanParameter("http.protocol.allow-circular-redirects", true);
        client.getParams().setBooleanParameter("http.protocol.single-cookie-header", true);
        return new HttpSenderContextParos(parent, initiator, this.getParam(), client);
    }

    int executeMethodImpl(HttpSenderContextParos ctx, HttpMethod method, HttpState state) throws IOException {
        int responseCode = -1;
        String hostName = method.getURI().getHost();
        method.setDoAuthentication(true);
        HostConfiguration hc = null;
        HttpClient requestClient = HttpSenderParos.isConnectionUpgrade(method) ? new HttpClient((HttpConnectionManager)new ZapHttpConnectionManager()) : ctx.getHttpClient();
        if (ctx.getInitiator() == 7) {
            hc = new HostConfiguration(){

                public synchronized void setHost(URI uri) {
                    try {
                        this.setHost(new HttpHost(uri.getHost(), uri.getPort(), this.getProtocol()));
                    }
                    catch (URIException e) {
                        throw new IllegalArgumentException(e.toString());
                    }
                }
            };
            hc.setHost(hostName, method.getURI().getPort(), new Protocol("https", (ProtocolSocketFactory)new SSLConnector(false), 443));
        }
        method.getParams().setBooleanParameter("socket.resolve.hostname", this.getParam().shouldResolveRemoteHostname(hostName));
        method.getParams().setParameter("method.connect.default.user.agent", (Object)this.getParam().getDefaultUserAgent());
        int timeout = (int)TimeUnit.SECONDS.toMillis(this.getParam().getTimeoutInSecs());
        method.getParams().setSoTimeout(timeout);
        httpConnManager.getParams().setConnectionTimeout(timeout);
        if (state != null) {
            method.getParams().setCookiePolicy("compatibility");
            this.setProxyAuth(state);
        } else {
            this.setProxyAuth(requestClient.getState());
        }
        if (this.getParam().isUseProxy(hostName)) {
            if (hc == null) {
                hc = new HostConfiguration();
                hc.setHost(hostName, method.getURI().getPort(), method.getURI().getScheme());
            }
            hc.setProxy(this.getParam().getProxyChainName(), this.getParam().getProxyChainPort());
        }
        responseCode = requestClient.executeMethod(hc, method, state);
        return responseCode;
    }

    private static boolean isConnectionUpgrade(HttpMethod method) {
        Header connectionHeader = method.getRequestHeader("connection");
        if (connectionHeader == null) {
            return false;
        }
        return connectionHeader.getValue().toLowerCase(Locale.ROOT).contains("upgrade");
    }

    @Override
    public void sendAndReceive(HttpSenderContextParos ctx, HttpRequestConfig config, HttpMessage message, Path file) throws IOException {
        HttpRequestConfig effectiveConfig = this.getEffectiveConfig(ctx, config);
        if (file != null) {
            this.sendAndReceive(ctx, message, effectiveConfig, (HttpMessage msg, HttpMethod method) -> {
                if (effectiveConfig.isFollowRedirects() && HttpSenderParos.isRedirectionNeeded(msg.getResponseHeader().getStatusCode())) {
                    DEFAULT_BODY_CONSUMER.accept(msg, method);
                    return;
                }
                HttpResponseHeader header = msg.getResponseHeader();
                try (FileChannel channel = (FileChannel)Files.newByteChannel(file, EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), new FileAttribute[0]);
                     InputStream is = method.getResponseBodyAsStream();){
                    long totalRead = 0L;
                    while ((totalRead += channel.transferFrom(Channels.newChannel(is), totalRead, 0x1000000L)) < (long)header.getContentLength()) {
                    }
                }
            });
        }
        this.sendAndReceive(ctx, message, effectiveConfig, DEFAULT_BODY_CONSUMER);
    }

    private HttpRequestConfig getEffectiveConfig(HttpSenderContextParos ctx, HttpRequestConfig config) {
        if (config != null) {
            return config;
        }
        return ctx.isFollowRedirects() ? FOLLOW_REDIRECTS : NO_REDIRECTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyRequestListeners(HttpSenderContextParos ctx, HttpMessage msg) {
        if (IN_LISTENER.get() != null) {
            return;
        }
        try {
            IN_LISTENER.set(true);
            for (HttpSenderListener listener : listeners) {
                try {
                    listener.onHttpRequestSend(msg, ctx.getInitiator(), ctx.getParent());
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            IN_LISTENER.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyResponseListeners(HttpSenderContextParos ctx, HttpMessage msg) {
        if (IN_LISTENER.get() != null) {
            return;
        }
        try {
            IN_LISTENER.set(true);
            for (HttpSenderListener listener : listeners) {
                try {
                    listener.onHttpResponseReceive(msg, ctx.getInitiator(), ctx.getParent());
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            IN_LISTENER.remove();
        }
    }

    private void sendAuthenticated(HttpSenderContextParos ctx, HttpMessage msg, HttpMethodParams params, ResponseBodyConsumer responseBodyConsumer) throws IOException {
        User forceUser = ctx.getUser(msg);
        if (forceUser != null) {
            if (ctx.getInitiator() == 15) {
                forceUser.processMessageToMatchAuthenticatedSession(msg);
            } else if (ctx.getInitiator() != 5) {
                forceUser.processMessageToMatchUser(msg);
            }
        }
        log.debug("Sending message to: {}", (Object)msg.getRequestHeader().getURI());
        this.send(ctx, msg, params, responseBodyConsumer);
        if (ctx.getInitiator() != 5 && ctx.getInitiator() != 15 && forceUser != null && !msg.getRequestHeader().isImage() && !forceUser.isAuthenticated(msg)) {
            log.debug("First try to send authenticated message failed for {}. Authenticating and trying again...", (Object)msg.getRequestHeader().getURI());
            forceUser.queueAuthentication(msg);
            forceUser.processMessageToMatchUser(msg);
            this.send(ctx, msg, params, responseBodyConsumer);
        } else {
            log.debug("SUCCESSFUL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(HttpSenderContextParos ctx, HttpMessage msg, HttpMethodParams params, ResponseBodyConsumer responseBodyConsumer) throws IOException {
        HttpMethod method = null;
        HttpResponseHeader resHeader = null;
        try {
            method = this.runMethod(ctx, msg, params);
            resHeader = HttpMethodHelper.getHttpResponseHeader(method);
            resHeader.setHeader("Transfer-Encoding", null);
            msg.setResponseHeader(resHeader);
            responseBodyConsumer.accept(msg, method);
            msg.setResponseFromTargetHost(true);
            if (method instanceof ZapGetMethod) {
                msg.setUserObject(method);
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private HttpMethod runMethod(HttpSenderContextParos ctx, HttpMessage msg, HttpMethodParams params) throws IOException {
        HttpMethod method = null;
        method = helper.createRequestMethod(msg.getRequestHeader(), msg.getRequestBody(), params);
        method.setFollowRedirects(false);
        HttpState state = null;
        User forceUser = ctx.getUser(msg);
        if (forceUser != null) {
            state = forceUser.getCorrespondingHttpState();
        }
        this.executeMethodImpl(ctx, method, state);
        HttpMethodHelper.updateHttpRequestHeaderSent(msg.getRequestHeader(), method);
        return method;
    }

    @Override
    public void addListener(HttpSenderListener listener) {
        Objects.requireNonNull(listener);
        listeners.add(listener);
        Collections.sort(listeners, LISTENERS_COMPARATOR);
    }

    @Override
    public void removeListener(HttpSenderListener listener) {
        Objects.requireNonNull(listener);
        listeners.remove(listener);
    }

    private void sendAndReceive(HttpSenderContextParos ctx, HttpMessage message, HttpRequestConfig requestConfig, ResponseBodyConsumer responseBodyConsumer) throws IOException {
        if (message == null) {
            throw new IllegalArgumentException("Parameter message must not be null.");
        }
        if (requestConfig == null) {
            throw new IllegalArgumentException("Parameter requestConfig must not be null.");
        }
        this.sendAndReceiveImpl(ctx, message, requestConfig, responseBodyConsumer);
        if (requestConfig.isFollowRedirects()) {
            this.followRedirections(ctx, message, requestConfig, responseBodyConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAndReceiveImpl(HttpSenderContextParos ctx, HttpMessage message, HttpRequestConfig requestConfig, ResponseBodyConsumer responseBodyConsumer) throws IOException {
        log.debug("Sending {} {}", (Object)message.getRequestHeader().getMethod(), (Object)message.getRequestHeader().getURI());
        message.setTimeSentMillis(System.currentTimeMillis());
        try {
            if (requestConfig.isNotifyListeners()) {
                HttpSenderParos.notifyRequestListeners(ctx, message);
            }
            HttpMethodParams params = null;
            if (requestConfig.getSoTimeout() != -1) {
                params = new HttpMethodParams();
                params.setSoTimeout(requestConfig.getSoTimeout());
            }
            this.sendAuthenticated(ctx, message, params, responseBodyConsumer);
        }
        finally {
            message.setTimeElapsedMillis((int)(System.currentTimeMillis() - message.getTimeSentMillis()));
            log.debug("Received response after {}ms for {} {}", (Object)message.getTimeElapsedMillis(), (Object)message.getRequestHeader().getMethod(), (Object)message.getRequestHeader().getURI());
            if (requestConfig.isNotifyListeners()) {
                HttpSenderParos.notifyResponseListeners(ctx, message);
            }
        }
    }

    private void followRedirections(HttpSenderContextParos ctx, HttpMessage message, HttpRequestConfig requestConfig, ResponseBodyConsumer responseBodyConsumer) throws IOException {
        HttpRedirectionValidator validator = requestConfig.getRedirectionValidator();
        validator.notifyMessageReceived(message);
        User requestingUser = ctx.getUser(message);
        HttpMessage redirectMessage = message;
        int maxRedirections = ctx.getHttpClient().getParams().getIntParameter("http.protocol.max-redirects", 100);
        for (int i = 0; i < maxRedirections && HttpSenderParos.isRedirectionNeeded(redirectMessage.getResponseHeader().getStatusCode()); ++i) {
            URI newLocation = HttpSenderParos.extractRedirectLocation(redirectMessage);
            if (newLocation == null || !validator.isValid(newLocation)) {
                return;
            }
            redirectMessage = redirectMessage.cloneAll();
            redirectMessage.setRequestingUser(requestingUser);
            redirectMessage.getRequestHeader().setURI(newLocation);
            if (HttpSenderParos.isRequestRewriteNeeded(redirectMessage)) {
                redirectMessage.getRequestHeader().setMethod("GET");
                redirectMessage.getRequestHeader().setHeader("Content-Type", null);
                redirectMessage.getRequestHeader().setHeader("Content-Length", null);
                redirectMessage.setRequestBody("");
            }
            this.sendAndReceiveImpl(ctx, redirectMessage, requestConfig, responseBodyConsumer);
            validator.notifyMessageReceived(redirectMessage);
            message.setResponseHeader(redirectMessage.getResponseHeader());
            message.setResponseBody(redirectMessage.getResponseBody());
        }
    }

    private static boolean isRedirectionNeeded(int statusCode) {
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    private static boolean isRequestRewriteNeeded(HttpMessage message) {
        int statusCode = message.getResponseHeader().getStatusCode();
        String method = message.getRequestHeader().getMethod();
        if (statusCode == 301 || statusCode == 302) {
            return "POST".equalsIgnoreCase(method);
        }
        return statusCode == 303 && !"GET".equalsIgnoreCase(method) && !"HEAD".equalsIgnoreCase(method);
    }

    private static URI extractRedirectLocation(HttpMessage message) throws InvalidRedirectLocationException {
        String location = message.getResponseHeader().getHeader("Location");
        if (location == null) {
            log.debug("No Location header found: {}", (Object)message.getResponseHeader());
            return null;
        }
        try {
            return new URI(message.getRequestHeader().getURI(), location, true);
        }
        catch (URIException ex) {
            try {
                return new URI(message.getRequestHeader().getURI(), location, false);
            }
            catch (URIException e) {
                throw new InvalidRedirectLocationException("Invalid redirect location: " + location, location, (Throwable)ex);
            }
        }
    }

    static {
        listeners = new ArrayList<HttpSenderListener>();
        LISTENERS_COMPARATOR = (o1, o2) -> Integer.compare(o1.getListenerOrder(), o2.getListenerOrder());
        sslConnector = new SSLConnector(true);
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)sslConnector, 443));
        Protocol.registerProtocol((String)"http", (Protocol)new Protocol("http", (ProtocolSocketFactory)new ProtocolSocketFactoryImpl(), 80));
        AuthPolicy.registerAuthScheme((String)"NTLM", ZapNTLMScheme.class);
        CookiePolicy.registerCookieSpec((String)"default", ZapCookieSpec.class);
        CookiePolicy.registerCookieSpec((String)"compatibility", ZapCookieSpec.class);
        helper = new HttpMethodHelper();
        IN_LISTENER = new ThreadLocal();
        NO_REDIRECTS = HttpRequestConfig.builder().build();
        FOLLOW_REDIRECTS = HttpRequestConfig.builder().setFollowRedirects(true).build();
        DEFAULT_BODY_CONSUMER = (msg, method) -> {
            if (msg.isEventStream()) {
                msg.getResponseBody().setCharset(msg.getResponseHeader().getCharset());
                msg.getResponseBody().setLength(0);
                return;
            }
            msg.setResponseBody(method.getResponseBody());
        };
    }

    private static class ProtocolSocketFactoryImpl
    implements ProtocolSocketFactory {
        private ProtocolSocketFactoryImpl() {
        }

        public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException {
            if (params == null) {
                throw new IllegalArgumentException("Parameters may not be null");
            }
            Socket socket = SocketFactory.getDefault().createSocket();
            socket.bind(new InetSocketAddress(localAddress, localPort));
            InetSocketAddress remoteAddress = params.getBooleanParameter("socket.resolve.hostname", true) ? new InetSocketAddress(host, port) : InetSocketAddress.createUnresolved(host, port);
            socket.connect(remoteAddress, params.getConnectionTimeout());
            return socket;
        }

        public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
            throw new UnsupportedOperationException("Method not supported, not required/called by Commons HttpClient library (version >= 3.0).");
        }

        public Socket createSocket(String host, int port) throws IOException {
            throw new UnsupportedOperationException("Method not supported, not required/called by Commons HttpClient library (version >= 3.0).");
        }
    }

    private static interface ResponseBodyConsumer {
        public void accept(HttpMessage var1, HttpMethod var2) throws IOException;
    }
}

