/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.Version;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnClassLoader;
import org.zaproxy.zap.control.AddOnCollection;
import org.zaproxy.zap.control.AddOnInstaller;
import org.zaproxy.zap.control.AddOnLoaderUtils;
import org.zaproxy.zap.control.AddOnRunIssuesUtils;
import org.zaproxy.zap.control.AddOnUninstallationProgressCallback;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public class AddOnLoader
extends URLClassLoader {
    public static final String ADDONS_BLOCK_LIST = "addons.block";
    private static final String ADDONS_RUNNABLE_BASE_KEY = "runnableAddOns";
    private static final String ADDONS_RUNNABLE_KEY = "runnableAddOns.addon";
    private static final String ADDON_RUNNABLE_ID_KEY = "id";
    private static final String ADDON_RUNNABLE_VERSION_KEY = "version";
    private static final String ADDON_RUNNABLE_FULL_VERSION_KEY = "fullversion";
    private static final String ADDON_RUNNABLE_ALL_EXTENSIONS_KEY = "extensions.extension";
    private static final AddOnUninstallationProgressCallback NULL_CALLBACK = new NullUninstallationProgressCallBack();
    private static final Logger logger = LogManager.getLogger(AddOnLoader.class);
    private Lock installationLock = new ReentrantLock();
    private AddOnCollection aoc = null;
    private List<File> jars = new ArrayList<File>();
    private List<String> blockList = new ArrayList<String>();
    private Map<AddOn, List<String>> runnableAddOns;
    private List<String> idsAddOnsWithRunningIssuesSinceLastRun;
    private Map<String, AddOnClassLoader> addOnLoaders = new HashMap<String, AddOnClassLoader>();
    private ZapXmlConfiguration addOnsStateConfig = new ZapXmlConfiguration();

    public AddOnLoader(File[] dirs) {
        super(new URL[0], AddOnLoader.class.getClassLoader());
        this.addOnsStateConfig.setRootElementName("addonsstate");
        File configFile = new File(Constant.getZapHome(), "add-ons-state.xml");
        this.addOnsStateConfig.setFile(configFile);
        if (!AddOnLoader.migrateOldAddOnsState(this.addOnsStateConfig) && configFile.exists()) {
            try {
                this.addOnsStateConfig.load();
            }
            catch (ConfigurationException e) {
                logger.warn("Failed to read add-ons' state file:", (Throwable)e);
            }
        }
        this.loadBlockList();
        this.aoc = new AddOnCollection(dirs);
        this.loadAllAddOns();
        if (dirs != null) {
            for (File dir : dirs) {
                try {
                    this.addDirectory(dir);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        for (File file : this.jars) {
            try {
                this.addURL(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        for (Map.Entry entry : this.addOnLoaders.entrySet()) {
            AddOnInstaller.installMissingAddOnFiles((AddOnClassLoader)entry.getValue(), this.getAddOnCollection().getAddOn((String)entry.getKey()));
        }
    }

    public List<String> getIdsAddOnsWithRunningIssuesSinceLastRun() {
        return Collections.unmodifiableList(this.idsAddOnsWithRunningIssuesSinceLastRun);
    }

    private void loadAllAddOns() {
        Iterator<AddOn> iterator = this.aoc.getAddOns().iterator();
        while (iterator.hasNext()) {
            AddOn addOn = iterator.next();
            if (this.canLoadAddOn(addOn)) {
                AddOnInstaller.installMissingAddOnLibs(addOn);
                continue;
            }
            iterator.remove();
        }
        this.runnableAddOns = new HashMap<AddOn, List<String>>();
        this.idsAddOnsWithRunningIssuesSinceLastRun = new ArrayList<String>();
        Map<AddOn, AddOnRunState> oldRunnableAddOns = AddOnLoader.loadAddOnsRunState((HierarchicalConfiguration)this.addOnsStateConfig, this.aoc);
        ArrayList<AddOn> runAddons = new ArrayList<AddOn>();
        HashSet<AddOn> updatedAddOns = new HashSet<AddOn>();
        HashSet<AddOn> nonRunnableAddOns = new HashSet<AddOn>();
        for (AddOn addOn : this.aoc.getAddOns()) {
            AddOn.AddOnRunRequirements reqs = AddOnLoader.calculateRunRequirements(addOn, this.aoc.getAddOns());
            if (reqs.isRunnable()) {
                List<Object> runnableExtensions;
                AddOnRunState runState = oldRunnableAddOns.get(addOn);
                if (addOn.hasExtensionsWithDeps()) {
                    List<Object> oldRunnableExtensions;
                    runnableExtensions = AddOnLoader.getRunnableExtensionsWithDeps(reqs);
                    List<Object> list = oldRunnableExtensions = runState != null ? runState.getExtensions() : Collections.emptyList();
                    if (!oldRunnableExtensions.isEmpty()) {
                        oldRunnableExtensions.removeAll(runnableExtensions);
                        if (!oldRunnableExtensions.isEmpty()) {
                            this.idsAddOnsWithRunningIssuesSinceLastRun.add(addOn.getId());
                        }
                    }
                } else {
                    runnableExtensions = Collections.emptyList();
                }
                this.runnableAddOns.put(addOn, runnableExtensions);
                runAddons.add(addOn);
                if (runState == null || !runState.hasNewerVersion()) continue;
                updatedAddOns.add(addOn);
                continue;
            }
            nonRunnableAddOns.add(addOn);
        }
        nonRunnableAddOns.stream().filter(oldRunnableAddOns::containsKey).map(AddOn::getId).forEach(this.idsAddOnsWithRunningIssuesSinceLastRun::add);
        this.saveAddOnsRunState(this.runnableAddOns);
        for (AddOn addOn : runAddons) {
            addOn.setInstallationStatus(AddOn.InstallationStatus.INSTALLED);
            AddOnClassLoader addOnClassLoader = this.createAndAddAddOnClassLoader(addOn);
            if (updatedAddOns.contains(addOn)) {
                AddOnInstaller.updateAddOnFiles(addOnClassLoader, addOn);
            }
            AddOnInstaller.installResourceBundle(addOnClassLoader, addOn);
        }
    }

    private static List<String> getRunnableExtensionsWithDeps(AddOn.AddOnRunRequirements runRequirements) {
        ArrayList<String> runnableExtensions = new ArrayList<String>();
        for (AddOn.ExtensionRunRequirements extReqs : runRequirements.getExtensionRequirements()) {
            if (!extReqs.isRunnable()) continue;
            runnableExtensions.add(extReqs.getClassname());
        }
        return runnableExtensions;
    }

    private boolean canLoadAddOn(AddOn ao) {
        if (this.blockList.contains(ao.getId())) {
            logger.debug("Can't load add-on {} it is on the block list (add-on uninstalled but the file couldn't be removed).", (Object)ao.getName());
            return false;
        }
        if (!ao.canLoadInCurrentVersion()) {
            logger.debug("Can't load add-on {} because of ZAP version constraints; Not before={} Not from={} Current Version={}", (Object)ao.getName(), (Object)ao.getNotBeforeVersion(), (Object)ao.getNotFromVersion(), (Object)Constant.PROGRAM_VERSION);
            return false;
        }
        return true;
    }

    private static AddOn.AddOnRunRequirements calculateRunRequirements(AddOn ao, Collection<AddOn> availableAddOns) {
        AddOn.AddOnRunRequirements reqs = ao.calculateRunRequirements(availableAddOns);
        if (!reqs.isRunnable() && logger.isDebugEnabled()) {
            logger.debug("Can't run add-on {} because of missing requirements: {}", (Object)ao.getName(), AddOnRunIssuesUtils.getRunningIssues(reqs));
        }
        return reqs;
    }

    private AddOnClassLoader createAndAddAddOnClassLoader(AddOn ao) {
        try {
            AddOnClassLoader addOnClassLoader = this.addOnLoaders.get(ao.getId());
            if (addOnClassLoader != null) {
                return addOnClassLoader;
            }
            List<String> idsAddOnDependencies = ao.getIdsAddOnDependencies();
            if (idsAddOnDependencies.isEmpty()) {
                addOnClassLoader = new AddOnClassLoader(ao.getFile().toURI().toURL(), this, ao.getAddOnClassnames());
                this.putAddOnClassLoader(ao, addOnClassLoader);
                return addOnClassLoader;
            }
            ArrayList<AddOnClassLoader> dependencies = new ArrayList<AddOnClassLoader>(idsAddOnDependencies.size());
            for (String addOnId : idsAddOnDependencies) {
                addOnClassLoader = this.addOnLoaders.get(addOnId);
                if (addOnClassLoader == null) {
                    addOnClassLoader = this.createAndAddAddOnClassLoader(this.aoc.getAddOn(addOnId));
                }
                dependencies.add(addOnClassLoader);
            }
            addOnClassLoader = new AddOnClassLoader(ao.getFile().toURI().toURL(), this, dependencies, ao.getAddOnClassnames());
            this.putAddOnClassLoader(ao, addOnClassLoader);
            return addOnClassLoader;
        }
        catch (MalformedURLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Failed to convert URL for AddOnClassLoader " + ao.getFile().toURI(), e);
        }
    }

    private void putAddOnClassLoader(AddOn ao, AddOnClassLoader addOnClassLoader) {
        if (!ao.getLibs().isEmpty()) {
            addOnClassLoader.addUrls(ao.getLibs().stream().map(AddOn.Lib::getFileSystemUrl).collect(Collectors.toList()));
        }
        ao.setClassLoader(addOnClassLoader);
        this.addOnLoaders.put(ao.getId(), addOnClassLoader);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            try {
                return this.loadClass(name, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
                for (AddOnClassLoader loader : this.addOnLoaders.values()) {
                    try {
                        return loader.loadClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        for (AddOnClassLoader childLoader : loader.getChildClassLoaders()) {
                            try {
                                return childLoader.loadClass(name);
                            }
                            catch (ClassNotFoundException classNotFoundException3) {
                            }
                        }
                    }
                }
                throw new ClassNotFoundException(name);
            }
        }
    }

    @Override
    protected Object getClassLoadingLock(String className) {
        return super.getClassLoadingLock(className);
    }

    @Override
    public URL getResource(String name) {
        URL url = super.getResource(name);
        if (url != null) {
            return url;
        }
        for (AddOnClassLoader loader : this.addOnLoaders.values()) {
            url = loader.findResourceInAddOn(name);
            if (url == null) continue;
            return url;
        }
        return url;
    }

    public AddOnCollection getAddOnCollection() {
        return this.aoc;
    }

    private void addDirectory(File dir) {
        if (dir == null) {
            logger.error("Null directory supplied");
            return;
        }
        if (!dir.exists()) {
            logger.debug("No such directory: {}", (Object)dir.getAbsolutePath());
            return;
        }
        if (!dir.isDirectory()) {
            logger.warn("Not a directory: {}", (Object)dir.getAbsolutePath());
            return;
        }
        File[] listJars = dir.listFiles(new JarFilenameFilter());
        if (listJars != null) {
            for (File jar : listJars) {
                this.jars.add(jar);
            }
        }
    }

    public void addAddon(AddOn ao) {
        if (!ao.canLoadInCurrentVersion()) {
            throw new IllegalArgumentException("Cant load add-on " + ao.getName() + " Not before=" + ao.getNotBeforeVersion() + " Not from=" + ao.getNotFromVersion() + " Version=" + Constant.PROGRAM_VERSION);
        }
        this.installationLock.lock();
        try {
            if (!this.aoc.addAddOn(ao)) {
                return;
            }
            this.addAddOnImpl(ao);
        }
        finally {
            this.installationLock.unlock();
        }
    }

    private void addAddOnImpl(AddOn ao) {
        if (AddOn.InstallationStatus.INSTALLED == ao.getInstallationStatus()) {
            return;
        }
        if (this.blockList.contains(ao.getId())) {
            this.blockList.remove(ao.getId());
            this.saveBlockList();
        }
        if (!AddOnLoader.isDynamicallyInstallable(ao)) {
            return;
        }
        if (!AddOnInstaller.installAddOnLibs(ao)) {
            ao.setInstallationStatus(AddOn.InstallationStatus.NOT_INSTALLED);
            return;
        }
        AddOn.AddOnRunRequirements reqs = AddOnLoader.calculateRunRequirements(ao, this.aoc.getInstalledAddOns());
        if (!reqs.isRunnable()) {
            ao.setInstallationStatus(AddOn.InstallationStatus.NOT_INSTALLED);
            return;
        }
        AddOnInstaller.install(this.createAndAddAddOnClassLoader(ao), ao);
        ao.setInstallationStatus(AddOn.InstallationStatus.INSTALLED);
        Control.getSingleton().getExtensionLoader().addOnInstalled(ao);
        if (this.runnableAddOns.get(ao) == null) {
            this.runnableAddOns.put(ao, AddOnLoader.getRunnableExtensionsWithDeps(reqs));
            this.saveAddOnsRunState(this.runnableAddOns);
        }
        this.checkAndLoadDependentExtensions();
        this.checkAndInstallAddOnsNotInstalled();
        if (View.isInitialised()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    View.getSingleton().refreshTabViewMenus();
                }
            });
        }
    }

    private void checkAndInstallAddOnsNotInstalled() {
        ArrayList<AddOn> runnableAddOns = new ArrayList<AddOn>();
        for (AddOn addOn : this.aoc.getAddOns()) {
            AddOn.AddOnRunRequirements reqs;
            if (AddOn.InstallationStatus.NOT_INSTALLED != addOn.getInstallationStatus() || this.addOnLoaders.get(addOn.getId()) != null || !(reqs = addOn.calculateRunRequirements(this.aoc.getInstalledAddOns())).isRunnable()) continue;
            runnableAddOns.add(addOn);
        }
        for (AddOn addOn : runnableAddOns) {
            this.addAddOnImpl(addOn);
        }
    }

    private void checkAndLoadDependentExtensions() {
        boolean changed = false;
        for (Map.Entry<String, AddOnClassLoader> entry : new HashMap<String, AddOnClassLoader>(this.addOnLoaders).entrySet()) {
            AddOn runningAddOn = this.aoc.getAddOn(entry.getKey());
            if (runningAddOn.getInstallationStatus() == AddOn.InstallationStatus.UNINSTALLATION_FAILED) continue;
            for (String extClassName : runningAddOn.getExtensionsWithDeps()) {
                AddOn.AddOnRunRequirements reqs;
                AddOn.ExtensionRunRequirements extReqs;
                if (runningAddOn.isExtensionLoaded(extClassName) || !(extReqs = (reqs = runningAddOn.calculateExtensionRunRequirements(extClassName, this.aoc.getInstalledAddOns())).getExtensionRequirements().get(0)).isRunnable()) continue;
                ArrayList<AddOnClassLoader> dependencies = new ArrayList<AddOnClassLoader>(extReqs.getDependencies().size());
                for (AddOn addOnDep : extReqs.getDependencies()) {
                    dependencies.add(this.addOnLoaders.get(addOnDep.getId()));
                }
                AddOnClassLoader extAddOnClassLoader = new AddOnClassLoader(entry.getValue(), dependencies, runningAddOn.getExtensionAddOnClassnames(extClassName));
                Extension ext = AddOnLoader.loadAddOnExtension(runningAddOn, extReqs.getClassname(), extAddOnClassLoader);
                if (ext == null) continue;
                AddOnInstaller.installAddOnExtension(runningAddOn, ext);
                this.runnableAddOns.get(runningAddOn).add(extReqs.getClassname());
                changed = true;
            }
        }
        if (changed) {
            this.saveAddOnsRunState(this.runnableAddOns);
        }
    }

    private static boolean isDynamicallyInstallable(AddOn addOn) {
        return addOn.hasZapAddOnEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAddOn(AddOn ao, boolean upgrading, AddOnUninstallationProgressCallback progressCallback) {
        this.installationLock.lock();
        try {
            AddOnUninstallationProgressCallback callback = progressCallback == null ? NULL_CALLBACK : progressCallback;
            callback.uninstallingAddOn(ao, upgrading);
            boolean removed = this.removeAddOnImpl(ao, upgrading, callback);
            callback.addOnUninstalled(removed);
            boolean bl = removed;
            return bl;
        }
        finally {
            this.installationLock.unlock();
        }
    }

    private boolean removeAddOnImpl(AddOn ao, boolean upgrading, AddOnUninstallationProgressCallback callback) {
        if (!AddOnLoader.isDynamicallyInstallable(ao)) {
            return false;
        }
        if (AddOn.InstallationStatus.SOFT_UNINSTALLATION_FAILED == ao.getInstallationStatus()) {
            if (this.runnableAddOns.remove(ao) != null) {
                this.saveAddOnsRunState(this.runnableAddOns);
            }
            AddOnInstaller.uninstallAddOnFiles(ao, NULL_CALLBACK, this.runnableAddOns.keySet());
            this.removeAddOnClassLoader(ao);
            this.deleteAddOn(ao, upgrading);
            ao.setInstallationStatus(AddOn.InstallationStatus.UNINSTALLATION_FAILED);
            Control.getSingleton().getExtensionLoader().addOnUninstalled(ao, false);
            return false;
        }
        if (!this.aoc.includesAddOn(ao.getId())) {
            logger.warn("Trying to uninstall an add-on that is not installed: {}", (Object)ao.getId());
            return false;
        }
        if (AddOn.InstallationStatus.NOT_INSTALLED == ao.getInstallationStatus()) {
            if (this.runnableAddOns.remove(ao) != null) {
                this.saveAddOnsRunState(this.runnableAddOns);
            }
            this.deleteAddOn(ao, upgrading);
            return this.aoc.removeAddOn(ao);
        }
        this.unloadDependentExtensions(ao);
        this.softUninstallDependentAddOns(ao);
        boolean uninstalledWithoutErrors = AddOnInstaller.uninstall(ao, callback, this.runnableAddOns.keySet());
        if (uninstalledWithoutErrors && !this.aoc.removeAddOn(ao)) {
            uninstalledWithoutErrors = false;
        }
        if (uninstalledWithoutErrors) {
            this.removeAddOnClassLoader(ao);
        }
        this.deleteAddOn(ao, upgrading);
        if (this.runnableAddOns.remove(ao) != null) {
            this.saveAddOnsRunState(this.runnableAddOns);
        }
        ao.setInstallationStatus(uninstalledWithoutErrors ? AddOn.InstallationStatus.AVAILABLE : AddOn.InstallationStatus.UNINSTALLATION_FAILED);
        Control.getSingleton().getExtensionLoader().addOnUninstalled(ao, uninstalledWithoutErrors);
        return uninstalledWithoutErrors;
    }

    private void deleteAddOn(AddOn addOn, boolean upgrading) {
        AddOnInstaller.uninstallAddOnLibs(addOn);
        if (addOn.getFile() != null && addOn.getFile().exists() && !addOn.getFile().delete() && !upgrading) {
            logger.debug("Can't delete {}", (Object)addOn.getFile().getAbsolutePath());
            this.blockList.add(addOn.getId());
            this.saveBlockList();
        }
    }

    private void removeAddOnClassLoader(AddOn addOn) {
        if (this.addOnLoaders.containsKey(addOn.getId())) {
            try (AddOnClassLoader addOnClassLoader = this.addOnLoaders.remove(addOn.getId());){
                if (!addOn.getIdsAddOnDependencies().isEmpty()) {
                    addOnClassLoader.clearDependencies();
                }
                ResourceBundle.clearCache(addOnClassLoader);
            }
            catch (Exception e) {
                logger.error("Failure while closing class loader of {} add-on:", (Object)addOn.getId(), (Object)e);
            }
            addOn.setClassLoader(null);
        }
    }

    private void unloadDependentExtensions(AddOn ao) {
        boolean changed = false;
        for (Map.Entry<String, AddOnClassLoader> entry : new HashMap<String, AddOnClassLoader>(this.addOnLoaders).entrySet()) {
            AddOn runningAddOn = this.aoc.getAddOn(entry.getKey());
            for (Extension ext : runningAddOn.getLoadedExtensionsWithDeps()) {
                if (!runningAddOn.dependsOn(ext, ao)) continue;
                String classname = ext.getClass().getCanonicalName();
                AddOnInstaller.uninstallAddOnExtension(runningAddOn, ext, NULL_CALLBACK);
                try (AddOnClassLoader extensionClassLoader = (AddOnClassLoader)ext.getClass().getClassLoader();){
                    ext = null;
                    entry.getValue().removeChildClassLoader(extensionClassLoader);
                    extensionClassLoader.clearDependencies();
                    ResourceBundle.clearCache(extensionClassLoader);
                }
                catch (Exception e) {
                    logger.error("Failure while closing class loader of extension '{}':", (Object)classname, (Object)e);
                }
                this.runnableAddOns.get(runningAddOn).remove(classname);
                changed = true;
            }
        }
        if (changed) {
            this.saveAddOnsRunState(this.runnableAddOns);
        }
    }

    private void softUninstallDependentAddOns(AddOn ao) {
        for (Map.Entry<String, AddOnClassLoader> entry : new HashMap<String, AddOnClassLoader>(this.addOnLoaders).entrySet()) {
            AddOn runningAddOn = this.aoc.getAddOn(entry.getKey());
            if (!runningAddOn.dependsOn(ao)) continue;
            this.softUninstallDependentAddOns(runningAddOn);
            this.softUninstall(runningAddOn);
        }
    }

    private void softUninstall(AddOn addOn) {
        AddOn.InstallationStatus status;
        if (AddOn.InstallationStatus.INSTALLED != addOn.getInstallationStatus()) {
            return;
        }
        if (AddOnLoader.isDynamicallyInstallable(addOn) && AddOnInstaller.softUninstall(addOn, NULL_CALLBACK)) {
            this.removeAddOnClassLoader(addOn);
            status = AddOn.InstallationStatus.NOT_INSTALLED;
        } else {
            status = AddOn.InstallationStatus.SOFT_UNINSTALLATION_FAILED;
        }
        addOn.setInstallationStatus(status);
        Control.getSingleton().getExtensionLoader().addOnSoftUninstalled(addOn, status == AddOn.InstallationStatus.NOT_INSTALLED);
    }

    private void loadBlockList() {
        this.blockList = AddOnLoader.loadList((Configuration)this.addOnsStateConfig, ADDONS_BLOCK_LIST);
    }

    private void saveBlockList() {
        AddOnLoader.saveList((FileConfiguration)this.addOnsStateConfig, ADDONS_BLOCK_LIST, this.blockList);
    }

    private <T> List<ClassNameWrapper> getClassNames(String packageName, Class<T> classType) {
        ArrayList<ClassNameWrapper> listClassName = new ArrayList<ClassNameWrapper>();
        listClassName.addAll(this.getLocalClassNames(packageName));
        for (String addOnId : this.addOnLoaders.keySet()) {
            listClassName.addAll(this.getJarClassNames(this.aoc.getAddOn(addOnId), packageName));
        }
        for (File jar : this.jars) {
            listClassName.addAll(this.getJarClassNames(this.getClass().getClassLoader(), jar, packageName));
        }
        return listClassName;
    }

    public List<Extension> getExtensions() {
        ArrayList<Extension> list = new ArrayList<Extension>();
        for (AddOn addOn : this.getAddOnCollection().getAddOns()) {
            list.addAll(this.getExtensions(addOn));
        }
        return list;
    }

    public List<Extension> getExtensions(AddOn addOn) {
        AddOnClassLoader addOnClassLoader = this.addOnLoaders.get(addOn.getId());
        if (addOnClassLoader == null) {
            return Collections.emptyList();
        }
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        extensions.addAll(this.loadAddOnExtensions(addOn, addOn.getExtensions(), addOnClassLoader));
        if (addOn.hasExtensionsWithDeps()) {
            AddOn.AddOnRunRequirements reqs = addOn.calculateRunRequirements(this.aoc.getInstalledAddOns());
            for (AddOn.ExtensionRunRequirements extReqs : reqs.getExtensionRequirements()) {
                if (extReqs.isRunnable()) {
                    ArrayList<AddOnClassLoader> dependencies = new ArrayList<AddOnClassLoader>(extReqs.getDependencies().size());
                    for (AddOn addOnDep : extReqs.getDependencies()) {
                        dependencies.add(this.addOnLoaders.get(addOnDep.getId()));
                    }
                    AddOnClassLoader extAddOnClassLoader = new AddOnClassLoader(addOnClassLoader, dependencies, addOn.getExtensionAddOnClassnames(extReqs.getClassname()));
                    Extension ext = AddOnLoader.loadAddOnExtension(addOn, extReqs.getClassname(), extAddOnClassLoader);
                    if (ext == null) continue;
                    extensions.add(ext);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Can't run extension '{}' of add-on '{}' because of missing requirements: {}", (Object)extReqs.getClassname(), (Object)addOn.getName(), AddOnRunIssuesUtils.getRunningIssues(extReqs));
            }
        }
        return extensions;
    }

    private List<Extension> loadAddOnExtensions(AddOn addOn, List<String> extensions, AddOnClassLoader addOnClassLoader) {
        if (extensions == null || extensions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Extension> list = new ArrayList<Extension>(extensions.size());
        for (String extName : extensions) {
            Extension ext = AddOnLoader.loadAddOnExtension(addOn, extName, addOnClassLoader);
            if (ext == null) continue;
            list.add(ext);
        }
        return list;
    }

    private static Extension loadAddOnExtension(AddOn addOn, String classname, AddOnClassLoader addOnClassLoader) {
        Extension extension = AddOnLoaderUtils.loadAndInstantiateClass(addOnClassLoader, classname, Extension.class, "extension");
        if (extension != null) {
            addOn.addLoadedExtension(extension);
        }
        return extension;
    }

    public List<AbstractPlugin> getActiveScanRules() {
        ArrayList<AbstractPlugin> list = new ArrayList<AbstractPlugin>();
        for (AddOn addOn : this.getAddOnCollection().getAddOns()) {
            AddOnClassLoader addOnClassLoader = this.addOnLoaders.get(addOn.getId());
            if (addOnClassLoader == null) continue;
            list.addAll(AddOnLoaderUtils.getActiveScanRules(addOn, addOnClassLoader));
        }
        list.trimToSize();
        this.validateNames(list);
        return Collections.unmodifiableList(list);
    }

    private void validateNames(List<?> scanRules) {
        scanRules.forEach(rule -> {
            String name;
            String string = name = rule instanceof AbstractPlugin ? ((AbstractPlugin)rule).getName() : ((PluginPassiveScanner)rule).getName();
            if (StringUtils.isBlank((CharSequence)name)) {
                logger.log(Constant.isDevBuild() ? Level.ERROR : Level.WARN, "Scan rule {} does not have a name.", (Object)rule.getClass().getCanonicalName());
            }
        });
    }

    public List<PluginPassiveScanner> getPassiveScanRules() {
        ArrayList<PluginPassiveScanner> list = new ArrayList<PluginPassiveScanner>();
        for (AddOn addOn : this.getAddOnCollection().getAddOns()) {
            AddOnClassLoader addOnClassLoader = this.addOnLoaders.get(addOn.getId());
            if (addOnClassLoader == null) continue;
            list.addAll(AddOnLoaderUtils.getPassiveScanRules(addOn, addOnClassLoader));
        }
        list.trimToSize();
        this.validateNames(list);
        return Collections.unmodifiableList(list);
    }

    @Deprecated
    public <T> List<T> getImplementors(String packageName, Class<T> classType) {
        return this.getImplementors(null, packageName, classType);
    }

    @Deprecated
    public <T> List<T> getImplementors(AddOn ao, String packageName, Class<T> classType) {
        Class<?> cls = null;
        ArrayList listClass = new ArrayList();
        List<ClassNameWrapper> classNames = ao != null ? this.getJarClassNames(ao, packageName) : this.getClassNames(packageName, classType);
        for (ClassNameWrapper classWrapper : classNames) {
            try {
                cls = classWrapper.getCl().loadClass(classWrapper.getClassName());
                if (Modifier.isAbstract(cls.getModifiers()) || Modifier.isInterface(cls.getModifiers()) || !classType.isAssignableFrom(cls)) continue;
                Constructor<?> c = cls.getConstructor(new Class[0]);
                listClass.add(c.newInstance(new Object[0]));
            }
            catch (Throwable e) {
                logger.debug(e.getMessage(), e);
            }
        }
        return listClass;
    }

    private List<ClassNameWrapper> getLocalClassNames(String packageName) {
        if (packageName == null || packageName.equals("")) {
            return Collections.emptyList();
        }
        String folder = packageName.replace('.', '/');
        URL local = AddOnLoader.class.getClassLoader().getResource(folder);
        if (local == null) {
            return Collections.emptyList();
        }
        String jarFile = null;
        if (local.getProtocol().equals("jar")) {
            jarFile = local.toString().substring("jar:".length());
            int pos = jarFile.indexOf("!");
            jarFile = jarFile.substring(0, pos);
            try {
                return this.getJarClassNames(this.getClass().getClassLoader(), new File(new URI(jarFile)), packageName);
            }
            catch (URISyntaxException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                return this.parseClassDir(this.getClass().getClassLoader(), new File(new URI(local.toString())), packageName.replace('.', File.separatorChar), new ClassRecurseDirFileFilter(true));
            }
            catch (URISyntaxException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    private List<ClassNameWrapper> parseClassDir(ClassLoader cl, File file, String packageName, FileFilter fileFilter) {
        File[] listFile;
        ArrayList<ClassNameWrapper> classNames = new ArrayList<ClassNameWrapper>();
        for (File entry : listFile = file.listFiles(fileFilter)) {
            if (entry.isDirectory()) {
                classNames.addAll(this.parseClassDir(cl, entry, packageName, fileFilter));
                continue;
            }
            String fileName = entry.toString();
            int pos = fileName.indexOf(packageName);
            if (pos <= 0) continue;
            String className = fileName.substring(pos).replaceAll("\\.class$", "").replace(File.separatorChar, '.');
            classNames.add(new ClassNameWrapper(cl, className));
        }
        return classNames;
    }

    private List<ClassNameWrapper> getJarClassNames(ClassLoader cl, File file, String packageName) {
        ArrayList<ClassNameWrapper> classNames = new ArrayList<ClassNameWrapper>();
        ZipEntry entry = null;
        String className = "";
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".class") || (className = entry.toString().replaceAll("\\.class$", "").replaceAll("/", ".")).indexOf(packageName) < 0) continue;
                classNames.add(new ClassNameWrapper(cl, className));
            }
        }
        catch (Exception e) {
            logger.error("Failed to open file: {}", (Object)file.getAbsolutePath(), (Object)e);
        }
        return classNames;
    }

    private List<ClassNameWrapper> getJarClassNames(AddOn ao, String packageName) {
        ArrayList<ClassNameWrapper> classNames = new ArrayList<ClassNameWrapper>();
        ZipEntry entry = null;
        String className = "";
        try (JarFile jarFile = new JarFile(ao.getFile());){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".class") || (className = entry.toString().replaceAll("\\.class$", "").replaceAll("/", ".")).indexOf(packageName) < 0) continue;
                classNames.add(new ClassNameWrapper(this.addOnLoaders.get(ao.getId()), className));
            }
        }
        catch (Exception e) {
            logger.error("Failed to open file: {}", (Object)ao.getFile().getAbsolutePath(), (Object)e);
        }
        return classNames;
    }

    private static List<String> loadList(Configuration config, String key) {
        ArrayList<String> data = new ArrayList<String>();
        String blockStr = config.getString(key, null);
        if (blockStr != null && blockStr.length() > 0) {
            for (String str : blockStr.split(",")) {
                data.add(str);
            }
        }
        return data;
    }

    private static void saveList(FileConfiguration config, String key, List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String id : list) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(id);
        }
        config.setProperty(key, (Object)sb.toString());
        try {
            config.save();
        }
        catch (ConfigurationException e) {
            logger.error("Failed to save list [{}]: {}", (Object)key, (Object)sb, (Object)e);
        }
    }

    private static Map<AddOn, AddOnRunState> loadAddOnsRunState(HierarchicalConfiguration config, AddOnCollection addOnCollection) {
        List savedAddOns = config.configurationsAt(ADDONS_RUNNABLE_KEY);
        HashMap<AddOn, AddOnRunState> runnableAddOns = new HashMap<AddOn, AddOnRunState>();
        for (HierarchicalConfiguration savedAddOn : savedAddOns) {
            AddOn addOn = addOnCollection.getAddOn(savedAddOn.getString(ADDON_RUNNABLE_ID_KEY, ""));
            if (addOn == null) continue;
            String version = savedAddOn.getString(ADDON_RUNNABLE_FULL_VERSION_KEY, "");
            if (version.isEmpty()) {
                version = savedAddOn.getString(ADDON_RUNNABLE_VERSION_KEY, "");
            }
            if (version.isEmpty()) continue;
            int result = addOn.getVersion().compareTo(AddOnLoader.createLegacyVersion(version, addOn.getName()));
            if (result != 0) {
                if (result <= 1) continue;
                runnableAddOns.put(addOn, new AddOnRunState());
                continue;
            }
            ArrayList<String> runnableExtensions = new ArrayList<String>();
            List<String> currentExtensions = addOn.getExtensionsWithDeps();
            for (String savedExtension : savedAddOn.getStringArray(ADDON_RUNNABLE_ALL_EXTENSIONS_KEY)) {
                if (!currentExtensions.contains(savedExtension)) continue;
                runnableExtensions.add(savedExtension);
            }
            runnableAddOns.put(addOn, new AddOnRunState(runnableExtensions));
        }
        return runnableAddOns;
    }

    private static Version createLegacyVersion(String version, String addOnName) {
        try {
            return new Version(version);
        }
        catch (IllegalArgumentException e) {
            logger.debug("Failed to create (legacy?) version with [{}] for runnable add-on [{}]", (Object)version, (Object)addOnName, (Object)e);
            try {
                return new Version(version + ".0.0");
            }
            catch (IllegalArgumentException e2) {
                logger.debug("Failed to create legacy version with [{}.0.0] for runnable add-on [{}]", (Object)version, (Object)addOnName, (Object)e2);
                return null;
            }
        }
    }

    private void saveAddOnsRunState(Map<AddOn, List<String>> runnableAddOns) {
        this.addOnsStateConfig.clearTree(ADDONS_RUNNABLE_BASE_KEY);
        int i = 0;
        for (Map.Entry<AddOn, List<String>> runnableAddOnEntry : runnableAddOns.entrySet()) {
            String elementBaseKey = "runnableAddOns.addon(" + i + ").";
            AddOn addOn = runnableAddOnEntry.getKey();
            this.addOnsStateConfig.setProperty(elementBaseKey + ADDON_RUNNABLE_ID_KEY, addOn.getId());
            this.addOnsStateConfig.setProperty(elementBaseKey + ADDON_RUNNABLE_FULL_VERSION_KEY, addOn.getVersion());
            this.addOnsStateConfig.setProperty(elementBaseKey + ADDON_RUNNABLE_VERSION_KEY, addOn.getVersion().getMajorVersion());
            String extensionBaseKey = elementBaseKey + ADDON_RUNNABLE_ALL_EXTENSIONS_KEY;
            for (String extension : runnableAddOnEntry.getValue()) {
                this.addOnsStateConfig.addProperty(extensionBaseKey, extension);
            }
            ++i;
        }
        try {
            this.addOnsStateConfig.save();
        }
        catch (ConfigurationException e) {
            logger.error("Failed to save state of runnable add-ons:", (Throwable)e);
        }
    }

    private static boolean migrateOldAddOnsState(ZapXmlConfiguration newConfig) {
        List oldAddOnsState;
        boolean dataMigrated = false;
        HierarchicalConfiguration oldConfig = (HierarchicalConfiguration)Model.getSingleton().getOptionsParam().getConfig();
        if (oldConfig.containsKey(ADDONS_BLOCK_LIST)) {
            List<String> blockList = AddOnLoader.loadList((Configuration)oldConfig, ADDONS_BLOCK_LIST);
            oldConfig.clearProperty(ADDONS_BLOCK_LIST);
            AddOnLoader.saveList((FileConfiguration)newConfig, ADDONS_BLOCK_LIST, blockList);
            dataMigrated = true;
        }
        if (!(oldAddOnsState = oldConfig.configurationsAt(ADDONS_RUNNABLE_KEY)).isEmpty()) {
            int i = 0;
            for (HierarchicalConfiguration savedAddOn : oldAddOnsState) {
                String elementBaseKey = "runnableAddOns.addon(" + i + ").";
                newConfig.setProperty(elementBaseKey + ADDON_RUNNABLE_ID_KEY, savedAddOn.getString(ADDON_RUNNABLE_ID_KEY, ""));
                String version = savedAddOn.getString(ADDON_RUNNABLE_FULL_VERSION_KEY, "");
                if (version.isEmpty()) {
                    newConfig.setProperty(elementBaseKey + ADDON_RUNNABLE_VERSION_KEY, savedAddOn.getString(ADDON_RUNNABLE_VERSION_KEY, ""));
                } else {
                    newConfig.setProperty(elementBaseKey + ADDON_RUNNABLE_FULL_VERSION_KEY, version);
                }
                String extensionBaseKey = elementBaseKey + ADDON_RUNNABLE_ALL_EXTENSIONS_KEY;
                for (String extension : savedAddOn.getStringArray(ADDON_RUNNABLE_ALL_EXTENSIONS_KEY)) {
                    newConfig.addProperty(extensionBaseKey, extension);
                }
            }
            oldConfig.clearTree(ADDONS_RUNNABLE_KEY);
            dataMigrated = true;
        }
        return dataMigrated;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    private static class AddOnRunState {
        private final boolean newerVersion;
        private final List<String> extensions;

        public AddOnRunState() {
            this.newerVersion = true;
            this.extensions = Collections.emptyList();
        }

        public AddOnRunState(List<String> extensions) {
            this.newerVersion = false;
            this.extensions = extensions;
        }

        public boolean hasNewerVersion() {
            return this.newerVersion;
        }

        public List<String> getExtensions() {
            return this.extensions;
        }
    }

    private static class NullUninstallationProgressCallBack
    implements AddOnUninstallationProgressCallback {
        private NullUninstallationProgressCallBack() {
        }

        @Override
        public void uninstallingAddOn(AddOn addOn, boolean updating) {
        }

        @Override
        public void activeScanRulesWillBeRemoved(int numberOfRules) {
        }

        @Override
        public void activeScanRuleRemoved(String name) {
        }

        @Override
        public void passiveScanRulesWillBeRemoved(int numberOfRules) {
        }

        @Override
        public void passiveScanRuleRemoved(String name) {
        }

        @Override
        public void filesWillBeRemoved(int numberOfFiles) {
        }

        @Override
        public void fileRemoved() {
        }

        @Override
        public void extensionsWillBeRemoved(int numberOfExtensions) {
        }

        @Override
        public void extensionRemoved(String name) {
        }

        @Override
        public void addOnUninstalled(boolean uninstalled) {
        }
    }

    private class ClassNameWrapper {
        private ClassLoader cl;
        private String className;

        public ClassNameWrapper(ClassLoader cl, String className) {
            this.cl = cl;
            this.className = className;
        }

        public ClassLoader getCl() {
            return this.cl;
        }

        public String getClassName() {
            return this.className;
        }
    }

    private static final class ClassRecurseDirFileFilter
    implements FileFilter {
        private boolean recurse;

        public ClassRecurseDirFileFilter(boolean recurse) {
            this.recurse = recurse;
        }

        @Override
        public boolean accept(File file) {
            if (this.recurse && file.isDirectory() && !file.getName().startsWith(".")) {
                return true;
            }
            return file.isFile() && file.getName().endsWith(".class");
        }
    }

    private static final class JarFilenameFilter
    implements FilenameFilter {
        private JarFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String fileName) {
            return fileName.endsWith(".jar");
        }
    }
}

