/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultListModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Scanner;
import org.parosproxy.paros.core.scanner.ScannerListener;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.ascan.ActiveScanEventPublisher;
import org.zaproxy.zap.extension.ascan.ActiveScanTableModel;
import org.zaproxy.zap.extension.ascan.FilterMessageTableModel;
import org.zaproxy.zap.extension.ascan.ResponseCountSnapshot;
import org.zaproxy.zap.extension.ascan.ScanPolicy;
import org.zaproxy.zap.extension.ruleconfig.RuleConfigParam;
import org.zaproxy.zap.model.GenericScanner2;
import org.zaproxy.zap.model.Target;

public class ActiveScan
extends Scanner
implements GenericScanner2,
ScannerListener {
    private static final int MAX_STATS_HISTORY_SIZE = 240;
    private String displayName = null;
    private int progress = 0;
    private ActiveScanTableModel messagesTableModel = new ActiveScanTableModel();
    private FilterMessageTableModel filterMessageTableModel = new FilterMessageTableModel();
    private SiteNode startNode = null;
    private ResponseCountSnapshot rcTotals = new ResponseCountSnapshot();
    private ResponseCountSnapshot rcLastSnapshot = new ResponseCountSnapshot();
    private List<ResponseCountSnapshot> rcHistory = new ArrayList<ResponseCountSnapshot>();
    private Date timeStarted = null;
    private Date timeFinished = null;
    private int maxResultsToList = 0;
    private final List<Integer> hRefs = Collections.synchronizedList(new ArrayList());
    private final List<Integer> alerts = Collections.synchronizedList(new ArrayList());
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> schedHandle;
    private static final Logger log = LogManager.getLogger(ActiveScan.class);

    @Deprecated
    public ActiveScan(String displayName, ScannerParam scannerParam, ConnectionParam param, ScanPolicy scanPolicy) {
        this(displayName, scannerParam, param, scanPolicy, null);
    }

    @Deprecated
    public ActiveScan(String displayName, ScannerParam scannerParam, ConnectionParam param, ScanPolicy scanPolicy, RuleConfigParam ruleConfigParam) {
        this(displayName, scannerParam, scanPolicy, ruleConfigParam);
    }

    public ActiveScan(String displayName, ScannerParam scannerParam, ScanPolicy scanPolicy, RuleConfigParam ruleConfigParam) {
        super(scannerParam, scanPolicy, ruleConfigParam);
        this.displayName = displayName;
        this.maxResultsToList = scannerParam.getMaxResultsToList();
        this.addScannerListener(this);
    }

    @Override
    public int getMaximum() {
        return 100;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public boolean isRunning() {
        return !this.isStop();
    }

    @Override
    public boolean isStopped() {
        return super.isStop();
    }

    @Override
    public void pauseScan() {
        if (this.isRunning()) {
            super.pause();
        }
    }

    public int getTotalRequests() {
        int total = 0;
        for (HostProcess process : this.getHostProcesses()) {
            total += process.getRequestCount();
        }
        return total;
    }

    public int getTotalNewAlerts() {
        int totalNewAlerts = 0;
        for (HostProcess process : this.getHostProcesses()) {
            totalNewAlerts += process.getNewAlertCount();
        }
        return totalNewAlerts;
    }

    public ResponseCountSnapshot getRequestHistory() {
        if (this.rcHistory.size() > 0) {
            try {
                return this.rcHistory.remove(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void start(Target target) {
        this.reset();
        this.timeStarted = new Date();
        this.progress = 0;
        int period = 2;
        super.start(target);
        if (View.isInitialised()) {
            this.scheduler = Executors.newScheduledThreadPool(1);
            Runnable requestCounter = new Runnable(){

                @Override
                public void run() {
                    if (ActiveScan.this.isStop()) {
                        ActiveScan.this.schedHandle.cancel(true);
                        return;
                    }
                    ResponseCountSnapshot currentSnapshot = ActiveScan.this.rcTotals.clone();
                    ActiveScan.this.rcHistory.add(currentSnapshot.getDifference(ActiveScan.this.rcLastSnapshot));
                    if (ActiveScan.this.rcHistory.size() > 240) {
                        ActiveScan.this.rcHistory.remove(0);
                    }
                    ActiveScan.this.rcLastSnapshot = currentSnapshot;
                }
            };
            this.schedHandle = this.scheduler.scheduleWithFixedDelay(requestCounter, 2L, 2L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void stopScan() {
        super.stop();
        if (this.schedHandle != null) {
            this.schedHandle.cancel(true);
        }
    }

    @Override
    public void resumeScan() {
        if (this.isPaused()) {
            super.resume();
        }
    }

    @Override
    public void alertFound(Alert alert) {
        int alertId = alert.getAlertId();
        if (alertId != -1) {
            this.alerts.add(alert.getAlertId());
        }
    }

    @Override
    public void hostComplete(int id, String hostAndPort) {
    }

    @Override
    public void hostNewScan(int id, String hostAndPort, HostProcess hostThread) {
    }

    @Override
    public void hostProgress(int id, String hostAndPort, String msg, int percentage) {
        int tot = 0;
        for (HostProcess process : this.getHostProcesses()) {
            tot += process.getPercentageComplete();
        }
        int latestProgress = tot / this.getHostProcesses().size();
        if (latestProgress != this.progress) {
            this.progress = latestProgress;
            ActiveScanEventPublisher.publishScanProgressEvent(this.getId(), this.progress);
        }
    }

    @Override
    public void filteredMessage(HttpMessage msg, String reason) {
        this.filterMessageTableModel.addResult(msg.getRequestHeader().getURI().toString(), reason);
    }

    @Override
    public void scannerComplete(int id) {
        this.timeFinished = new Date();
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    public DefaultListModel<HistoryReference> getList() {
        return null;
    }

    FilterMessageTableModel getFilterMessageTableModel() {
        return this.filterMessageTableModel;
    }

    public ActiveScanTableModel getMessagesTableModel() {
        return this.messagesTableModel;
    }

    @Override
    public void notifyNewMessage(HttpMessage msg) {
        HistoryReference hRef = msg.getHistoryRef();
        if (hRef == null) {
            try {
                hRef = new HistoryReference(Model.getSingleton().getSession(), 14, msg);
                msg.setHistoryRef(null);
                this.hRefs.add(hRef.getHistoryId());
            }
            catch (DatabaseException | HttpMalformedHeaderException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            this.hRefs.add(hRef.getHistoryId());
        }
        this.rcTotals.incResponseCodeCount(msg.getResponseHeader().getStatusCode());
        if (hRef != null && View.isInitialised()) {
            if (this.rcTotals.getTotal() > this.maxResultsToList) {
                this.removeFirstHistoryReferenceInEdt();
            }
            this.addHistoryReferenceInEdt(hRef);
        }
    }

    private void addHistoryReferenceInEdt(final HistoryReference hRef) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ActiveScan.this.messagesTableModel.addHistoryReference(hRef);
            }
        });
    }

    private void removeFirstHistoryReferenceInEdt() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ActiveScan.this.messagesTableModel.removeHistoryReference(ActiveScan.this.getMessagesTableModel().getEntry(0).getHistoryReference());
            }
        });
    }

    @Override
    public SiteNode getStartNode() {
        return this.startNode;
    }

    @Override
    public void setStartNode(SiteNode startNode) {
        this.startNode = startNode;
        super.setStartNode(startNode);
    }

    public void reset() {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            this.messagesTableModel.clear();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActiveScan.this.reset();
                }
            });
        }
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public List<Integer> getMessagesIds() {
        return this.hRefs;
    }

    public List<Integer> getAlertsIds() {
        return this.alerts;
    }

    public State getState() {
        if (this.timeStarted == null) {
            return State.NOT_STARTED;
        }
        if (this.isStop()) {
            return State.FINISHED;
        }
        if (this.isPaused()) {
            return State.PAUSED;
        }
        return State.RUNNING;
    }

    @Override
    public void setDisplayName(String name) {
        this.displayName = name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setScanId(int id) {
        this.setId(id);
    }

    @Override
    public int getScanId() {
        return this.getId();
    }

    public static enum State {
        NOT_STARTED,
        RUNNING,
        PAUSED,
        FINISHED;

    }
}

