/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan.scanner;

import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import net.htmlparser.jericho.Source;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.StringUtils;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.utils.Stats;

public class StatsPassiveScanner
extends PluginPassiveScanner {
    public static final String CODE_STATS_PREFIX = "stats.code.";
    public static final String CONTENT_TYPE_STATS_PREFIX = "stats.contentType.";
    public static final String RESPONSE_TIME_STATS_PREFIX = "stats.responseTime.";

    @Override
    public String getName() {
        return Constant.messages.getString("pscan.stats.passivescanner.title");
    }

    @Override
    public int getPluginId() {
        return 50003;
    }

    @Override
    public StatsPassiveScanner copy() {
        return new StatsPassiveScanner();
    }

    @Override
    public void scanHttpResponseReceive(HttpMessage msg, int id, Source source) {
        try {
            String site = SessionStructure.getHostName(msg);
            Stats.incCounter(site, CODE_STATS_PREFIX + msg.getResponseHeader().getStatusCode());
            String contentType = msg.getResponseHeader().getHeader("Content-Type");
            if (contentType != null) {
                Stats.incCounter(site, CONTENT_TYPE_STATS_PREFIX + StatsPassiveScanner.getContentTypePostfix(contentType));
            }
            Stats.incCounter(site, RESPONSE_TIME_STATS_PREFIX + Integer.highestOneBit(msg.getTimeElapsedMillis()) * 2);
        }
        catch (URIException uRIException) {
            // empty catch block
        }
    }

    private static String getContentTypePostfix(String contentTypeValue) {
        String[] ctvArray = contentTypeValue.split(";");
        if (ctvArray.length == 1) {
            return ctvArray[0].trim();
        }
        return Arrays.stream(ctvArray).filter(StringUtils::isNotBlank).filter(segment -> !segment.toLowerCase(Locale.ROOT).contains("boundary")).map(String::trim).collect(Collectors.joining("; "));
    }

    @Override
    public boolean appliesToHistoryType(int historyType) {
        return true;
    }
}

