/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.zaproxy.zap.extension.script.ScriptWrapper;

public class ScriptParam
extends AbstractParam {
    private static final String SCRIPTS_BASE_KEY = "script";
    private static final String PARAM_DEFAULT_SCRIPT = "script.defaultScript";
    private static final String PARAM_DEFAULT_DIR = "script.defaultDir";
    private static final String ALL_SCRIPTS_KEY = "script.scripts";
    private static final String SCRIPT_NAME_KEY = "name";
    private static final String SCRIPT_DESC_KEY = "description";
    private static final String SCRIPT_ENGINE_KEY = "engine";
    private static final String SCRIPT_TYPE_KEY = "type";
    private static final String SCRIPT_FILE_KEY = "file";
    private static final String SCRIPT_ENABLED_KEY = "enabled";
    private static final String SCRIPT_DIRS = "dirs";
    private static final String SCRIPT_CONFIRM_REMOVE_DIR = "confRemdir";
    private static final Logger logger = LogManager.getLogger(ScriptParam.class);
    private String defaultScript = null;
    private String defaultDir = null;
    private Set<ScriptWrapper> scripts;
    private List<File> scriptDirs;
    private boolean confirmRemoveDir = true;

    @Override
    protected void parse() {
        this.defaultScript = this.getString(PARAM_DEFAULT_SCRIPT, "");
        this.defaultDir = this.getString(PARAM_DEFAULT_DIR, "");
        try {
            List fields = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_SCRIPTS_KEY);
            this.scripts = new HashSet<ScriptWrapper>(fields.size());
            ArrayList<String> tempListNames = new ArrayList<String>(fields.size());
            for (HierarchicalConfiguration sub : fields) {
                String name = sub.getString(SCRIPT_NAME_KEY, "");
                try {
                    if ("".equals(name) || tempListNames.contains(name)) continue;
                    tempListNames.add(name);
                    File file = new File(sub.getString(SCRIPT_FILE_KEY));
                    if (!file.exists()) {
                        logger.error("Script '{}' does not exist", (Object)file.getAbsolutePath());
                        continue;
                    }
                    ScriptWrapper script = new ScriptWrapper(sub.getString(SCRIPT_NAME_KEY), sub.getString(SCRIPT_DESC_KEY), sub.getString(SCRIPT_ENGINE_KEY), sub.getString(SCRIPT_TYPE_KEY), sub.getBoolean(SCRIPT_ENABLED_KEY), file);
                    script.setLoadOnStart(true);
                    this.scripts.add(script);
                }
                catch (Exception e) {
                    logger.error("Error while loading the script: {}", (Object)name, (Object)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while loading the scripts: {}", (Object)e.getMessage(), (Object)e);
        }
        try {
            this.scriptDirs = new ArrayList<File>();
            for (Object dirName : this.getConfig().getList(SCRIPT_DIRS)) {
                File f = new File((String)dirName);
                if (!f.exists() || !f.isDirectory()) {
                    logger.error("Not a valid script directory: {}", dirName);
                    continue;
                }
                this.scriptDirs.add(f);
            }
        }
        catch (Exception e) {
            logger.error("Error while loading the script dirs: {}", (Object)e.getMessage(), (Object)e);
        }
        this.confirmRemoveDir = this.getBoolean(SCRIPT_CONFIRM_REMOVE_DIR, true);
    }

    public void addScript(ScriptWrapper script) {
        this.scripts.add(script);
    }

    public void removeScript(ScriptWrapper script) {
        this.scripts.remove(script);
    }

    public void saveScripts() {
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_SCRIPTS_KEY);
        int i = 0;
        for (ScriptWrapper script : this.scripts) {
            if (!script.isLoadOnStart()) continue;
            String elementBaseKey = "script.scripts(" + i + ").";
            this.getConfig().setProperty(elementBaseKey + SCRIPT_NAME_KEY, (Object)script.getName());
            this.getConfig().setProperty(elementBaseKey + SCRIPT_DESC_KEY, (Object)script.getDescription());
            this.getConfig().setProperty(elementBaseKey + SCRIPT_ENGINE_KEY, (Object)script.getEngineName());
            this.getConfig().setProperty(elementBaseKey + SCRIPT_TYPE_KEY, (Object)script.getTypeName());
            this.getConfig().setProperty(elementBaseKey + SCRIPT_ENABLED_KEY, (Object)script.isEnabled());
            this.getConfig().setProperty(elementBaseKey + SCRIPT_FILE_KEY, (Object)script.getFile().getAbsolutePath());
            ++i;
        }
    }

    public Set<ScriptWrapper> getScripts() {
        return this.scripts;
    }

    public void addScriptDir(File dir) {
        this.scriptDirs.add(dir);
        this.saveScriptDirs();
    }

    public void removeScriptDir(File dir) {
        this.scriptDirs.remove(dir);
        this.saveScriptDirs();
    }

    private void saveScriptDirs() {
        this.getConfig().setProperty(SCRIPT_DIRS, this.scriptDirs);
    }

    public List<File> getScriptDirs() {
        return this.scriptDirs;
    }

    public void setScriptDirs(List<File> scriptDirs) {
        this.scriptDirs = scriptDirs;
        this.saveScriptDirs();
    }

    public String getDefaultScript() {
        return this.defaultScript;
    }

    public void setDefaultScript(String defaultScript) {
        this.defaultScript = defaultScript;
        this.getConfig().setProperty(PARAM_DEFAULT_SCRIPT, (Object)this.defaultScript);
    }

    public String getDefaultDir() {
        return this.defaultDir;
    }

    public void setDefaultDir(String defaultDir) {
        this.defaultDir = defaultDir;
        this.getConfig().setProperty(PARAM_DEFAULT_DIR, (Object)this.defaultDir);
    }

    public void setConfirmRemoveDir(boolean confirmRemoveDir) {
        this.confirmRemoveDir = confirmRemoveDir;
        this.getConfig().setProperty(SCRIPT_CONFIRM_REMOVE_DIR, (Object)this.confirmRemoveDir);
    }

    public boolean isConfirmRemoveDir() {
        return this.confirmRemoveDir;
    }
}

