/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.uiutils;

import java.awt.EventQueue;
import java.util.Arrays;
import javax.swing.UIManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.MainFrame;

public class ExtensionUiUtils
extends ExtensionAdaptor
implements SessionChangedListener {
    public static final String NAME = "ExtensionUiUtils";
    private static final Logger LOGGER = LogManager.getLogger(ExtensionUiUtils.class);

    public ExtensionUiUtils() {
        super(NAME);
        this.setOrder(200);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("uiutils.name");
    }

    @Override
    public void initView(ViewDelegate view) {
        super.initView(view);
        Arrays.asList(new UIManager.LookAndFeelInfo("Flat Light", "com.formdev.flatlaf.FlatLightLaf"), new UIManager.LookAndFeelInfo("Flat Dark", "com.formdev.flatlaf.FlatDarkLaf"), new UIManager.LookAndFeelInfo("Flat IntelliJ", "com.formdev.flatlaf.FlatIntelliJLaf"), new UIManager.LookAndFeelInfo("Flat Darcula", "com.formdev.flatlaf.FlatDarculaLaf")).forEach(UIManager::installLookAndFeel);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.addSessionListener(this);
        }
    }

    @Override
    public void sessionChanged(final Session session) {
        if (EventQueue.isDispatchThread()) {
            this.sessionChangedEventHandler(session);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionUiUtils.this.sessionChangedEventHandler(session);
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void sessionChangedEventHandler(Session session) {
        if (session != null && !session.isNewState()) {
            this.getModel().getOptionsParam().getViewParam().addLatestSession(session.getFileName());
        }
        MainFrame mainFrame = this.getView().getMainFrame();
        mainFrame.getMainMenuBar().sessionChanged(session);
        mainFrame.getMainToolbarPanel().sessionChanged(session);
        mainFrame.setTitle(session);
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public void sessionPropertiesChanged(Session session) {
        if (EventQueue.isDispatchThread()) {
            this.getView().getMainFrame().setTitle(session);
            return;
        }
        EventQueue.invokeLater(() -> this.sessionPropertiesChanged(session));
    }

    @Override
    public boolean isCore() {
        return true;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("uiutils.desc");
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }
}

