/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.ScanPanel;
import org.zaproxy.zap.view.widgets.ContextSelectComboBox;

public abstract class AbstractContextSelectToolbarStatusPanel
extends AbstractPanel
implements Session.OnContextsChangedListener {
    private static final long serialVersionUID = 7164298579345445108L;
    private static final Logger log = LogManager.getLogger(AbstractContextSelectToolbarStatusPanel.class);
    protected static final short TOOLBAR_LOCATION_START = 0;
    protected static final short TOOLBAR_LOCATION_AFTER_CONTEXTS_SELECT = 1;
    protected static final short TOOLBAR_LOCATION_END = 99;
    protected String panelPrefix;
    private JToolBar panelToolbar = null;
    private JButton optionsButton = null;
    private ContextSelectComboBox contextSelectBox;

    public AbstractContextSelectToolbarStatusPanel(String prefix, ImageIcon icon) {
        this.panelPrefix = prefix;
        this.initialize(icon);
    }

    private void initialize(ImageIcon icon) {
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(474, 251);
        }
        this.setName(Constant.messages.getString(this.panelPrefix + ".panel.title"));
        this.setIcon(icon);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getPanelToolbar(), LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0, 2));
        this.add(this.getWorkPanel(), LayoutHelper.getGBC(0, 1, 1, 1.0, 1.0, 1));
        Model.getSingleton().getSession().addOnContextsChangedListener(this);
    }

    private JToolBar getPanelToolbar() {
        if (this.panelToolbar == null) {
            this.panelToolbar = new JToolBar();
            this.panelToolbar.setLayout(new GridBagLayout());
            this.panelToolbar.setEnabled(true);
            this.panelToolbar.setFloatable(false);
            this.panelToolbar.setRollover(true);
            this.panelToolbar.setPreferredSize(new Dimension(800, 30));
            this.panelToolbar.setName(this.panelPrefix + ".toolbar");
            this.setupToolbarElements(this.panelToolbar);
        }
        return this.panelToolbar;
    }

    protected void setupToolbarElements(JToolBar toolbar) {
        int x = 0;
        Insets insets = new Insets(0, 4, 0, 2);
        x = this.addToolBarElements(toolbar, (short)0, x);
        toolbar.add((Component)new JLabel(Constant.messages.getString(this.panelPrefix + ".toolbar.context.label")), LayoutHelper.getGBC(x++, 0, 1, 0.0, insets));
        toolbar.add((Component)this.getContextSelectComboBox(), LayoutHelper.getGBC(x++, 0, 1, 0.0, insets));
        x = this.addToolBarElements(toolbar, (short)1, x);
        toolbar.add((Component)new JLabel(), LayoutHelper.getGBC(x++, 0, 1, 1.0));
        if (this.hasOptions()) {
            toolbar.add((Component)this.getOptionsButton(), LayoutHelper.getGBC(x++, 0, 1, 0.0, insets));
        }
        this.addToolBarElements(toolbar, (short)99, x);
    }

    protected JButton getOptionsButton() {
        if (this.optionsButton == null) {
            this.optionsButton = new JButton();
            this.optionsButton.setToolTipText(Constant.messages.getString(this.panelPrefix + ".toolbar.button.options"));
            this.optionsButton.setIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/041.png")));
            this.optionsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Control.getSingleton().getMenuToolsControl().options(Constant.messages.getString(AbstractContextSelectToolbarStatusPanel.this.panelPrefix + ".options.title"));
                }
            });
        }
        return this.optionsButton;
    }

    protected ContextSelectComboBox getContextSelectComboBox() {
        if (this.contextSelectBox == null) {
            this.contextSelectBox = new ContextSelectComboBox();
            this.contextSelectBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractContextSelectToolbarStatusPanel.this.contextSelected((Context)AbstractContextSelectToolbarStatusPanel.this.contextSelectBox.getSelectedItem());
                }
            });
        }
        return this.contextSelectBox;
    }

    protected int addToolBarElements(JToolBar toolBar, short location, int gridX) {
        return gridX;
    }

    protected void contextSelected(Context context) {
        log.debug("Selected new context: {}", (Object)context);
        this.switchViewForContext(context);
    }

    public Context getSelectedContext() {
        return this.contextSelectBox.getSelectedContext();
    }

    @Override
    public void contextAdded(Context context) {
        log.debug("Context added...");
        this.contextSelectBox.reloadContexts(true);
    }

    @Override
    public void contextDeleted(Context context) {
        log.debug("Context deleted...");
        this.contextSelectBox.reloadContexts(false);
        this.contextSelectBox.setSelectedIndex(-1);
    }

    @Override
    public void contextsChanged() {
        log.debug("Contexts changed...");
        this.contextSelectBox.reloadContexts(false);
        this.contextSelectBox.setSelectedIndex(-1);
    }

    public void unload() {
        Model.getSingleton().getSession().removeOnContextsChangedListener(this);
    }

    protected boolean hasOptions() {
        return true;
    }

    protected abstract Component getWorkPanel();

    protected abstract void switchViewForContext(Context var1);
}

