//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.9
//
// <auto-generated>
//
// Generated from file `Session.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Glacier2;

/**
 * An object for managing the set of object identity constraints on a
 * {@link Session}.
 *
 * @see Session
 * @see SessionControl
 **/
public interface IdentitySet extends com.zeroc.Ice.Object
{
    /**
     * Add a sequence of Ice identities to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of Ice identities to be added.
     * @param current The Current object for the invocation.
     **/
    void add(com.zeroc.Ice.Identity[] additions, com.zeroc.Ice.Current current);

    /**
     * Remove a sequence of identities from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of Ice identities to be removed.
     * @param current The Current object for the invocation.
     **/
    void remove(com.zeroc.Ice.Identity[] deletions, com.zeroc.Ice.Current current);

    /**
     * Returns a sequence of identities describing the constraints in this
     * set.
     * @param current The Current object for the invocation.
     * @return The sequence of Ice identities for this set.
     **/
    com.zeroc.Ice.Identity[] get(com.zeroc.Ice.Current current);

    /** @hidden */
    static final String[] _iceIds =
    {
        "::Glacier2::IdentitySet",
        "::Ice::Object"
    };

    @Override
    default String[] ice_ids(com.zeroc.Ice.Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(com.zeroc.Ice.Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::Glacier2::IdentitySet";
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_add(IdentitySet obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        com.zeroc.Ice.Identity[] iceP_additions;
        iceP_additions = com.zeroc.Ice.IdentitySeqHelper.read(istr);
        inS.endReadParams();
        obj.add(iceP_additions, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_remove(IdentitySet obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        com.zeroc.Ice.Identity[] iceP_deletions;
        iceP_deletions = com.zeroc.Ice.IdentitySeqHelper.read(istr);
        inS.endReadParams();
        obj.remove(iceP_deletions, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_get(IdentitySet obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        com.zeroc.Ice.Identity[] ret = obj.get(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        com.zeroc.Ice.IdentitySeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /** @hidden */
    final static String[] _iceOps =
    {
        "add",
        "get",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping",
        "remove"
    };

    /** @hidden */
    @Override
    default java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return _iceD_add(this, in, current);
            }
            case 1:
            {
                return _iceD_get(this, in, current);
            }
            case 2:
            {
                return com.zeroc.Ice.Object._iceD_ice_id(this, in, current);
            }
            case 3:
            {
                return com.zeroc.Ice.Object._iceD_ice_ids(this, in, current);
            }
            case 4:
            {
                return com.zeroc.Ice.Object._iceD_ice_isA(this, in, current);
            }
            case 5:
            {
                return com.zeroc.Ice.Object._iceD_ice_ping(this, in, current);
            }
            case 6:
            {
                return _iceD_remove(this, in, current);
            }
        }

        assert(false);
        throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
    }
}
