//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.9
//
// <auto-generated>
//
// Generated from file `Router.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Glacier2;

/**
 * The Glacier2 specialization of the <code>Ice::Router</code> interface.
 **/
public interface Router extends com.zeroc.Ice.Router
{
    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty
     * string.
     * @param current The Current object for the invocation.
     * @return The category.
     **/
    String getCategoryForClient(com.zeroc.Ice.Current current);

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param userId The user id for which to check the password.
     * @param password The password for the given user id.
     * @param current The Current object for the invocation.
     * @return A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     * @throws CannotCreateSessionException Raised if the session
     * cannot be created.
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     **/
    java.util.concurrent.CompletionStage<SessionPrx> createSessionAsync(String userId, String password, com.zeroc.Ice.Current current)
        throws CannotCreateSessionException,
               PermissionDeniedException;

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param current The Current object for the invocation.
     * @return A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     * @throws CannotCreateSessionException Raised if the session
     * cannot be created.
     * @throws PermissionDeniedException Raised if the user cannot be
     * authenticated or if the user is not allowed access.
     *
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     **/
    java.util.concurrent.CompletionStage<SessionPrx> createSessionFromSecureConnectionAsync(com.zeroc.Ice.Current current)
        throws CannotCreateSessionException,
               PermissionDeniedException;

    /**
     * Keep the calling client's session with this router alive.
     * @param current The Current object for the invocation.
     * @return A completion stage that the servant will complete when the invocation completes.
     * @throws SessionNotExistException Raised if no session exists
     * for the calling client.
     **/
    java.util.concurrent.CompletionStage<Void> refreshSessionAsync(com.zeroc.Ice.Current current)
        throws SessionNotExistException;

    /**
     * Destroy the calling client's session with this router.
     * @param current The Current object for the invocation.
     * @throws SessionNotExistException Raised if no session exists
     * for the calling client.
     **/
    void destroySession(com.zeroc.Ice.Current current)
        throws SessionNotExistException;

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * @param current The Current object for the invocation.
     * @return The timeout (in seconds).
     **/
    long getSessionTimeout(com.zeroc.Ice.Current current);

    /**
     * Get the value of the ACM timeout. Clients supporting connection
     * heartbeats can enable them instead of explicitly sending keep
     * alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param current The Current object for the invocation.
     * @return The timeout (in seconds).
     **/
    int getACMTimeout(com.zeroc.Ice.Current current);

    /** @hidden */
    static final String[] _iceIds =
    {
        "::Glacier2::Router",
        "::Ice::Object",
        "::Ice::Router"
    };

    @Override
    default String[] ice_ids(com.zeroc.Ice.Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(com.zeroc.Ice.Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::Glacier2::Router";
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getCategoryForClient(Router obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        String ret = obj.getCategoryForClient(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeString(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_createSession(Router obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_userId;
        String iceP_password;
        iceP_userId = istr.readString();
        iceP_password = istr.readString();
        inS.endReadParams();
        inS.setFormat(com.zeroc.Ice.FormatType.SlicedFormat);
        return inS.setResultFuture(obj.createSessionAsync(iceP_userId, iceP_password, current), (ostr, ret) ->
            {
                ostr.writeProxy(ret);
            });
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_createSessionFromSecureConnection(Router obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        inS.readEmptyParams();
        inS.setFormat(com.zeroc.Ice.FormatType.SlicedFormat);
        return inS.setResultFuture(obj.createSessionFromSecureConnectionAsync(current), (ostr, ret) ->
            {
                ostr.writeProxy(ret);
            });
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_refreshSession(Router obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        inS.readEmptyParams();
        return inS.setResultFuture(obj.refreshSessionAsync(current));
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_destroySession(Router obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        inS.readEmptyParams();
        obj.destroySession(current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getSessionTimeout(Router obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        long ret = obj.getSessionTimeout(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeLong(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getACMTimeout(Router obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        int ret = obj.getACMTimeout(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeInt(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /** @hidden */
    final static String[] _iceOps =
    {
        "addProxies",
        "createSession",
        "createSessionFromSecureConnection",
        "destroySession",
        "getACMTimeout",
        "getCategoryForClient",
        "getClientProxy",
        "getServerProxy",
        "getSessionTimeout",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping",
        "refreshSession"
    };

    /** @hidden */
    @Override
    default java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return com.zeroc.Ice.Router._iceD_addProxies(this, in, current);
            }
            case 1:
            {
                return _iceD_createSession(this, in, current);
            }
            case 2:
            {
                return _iceD_createSessionFromSecureConnection(this, in, current);
            }
            case 3:
            {
                return _iceD_destroySession(this, in, current);
            }
            case 4:
            {
                return _iceD_getACMTimeout(this, in, current);
            }
            case 5:
            {
                return _iceD_getCategoryForClient(this, in, current);
            }
            case 6:
            {
                return com.zeroc.Ice.Router._iceD_getClientProxy(this, in, current);
            }
            case 7:
            {
                return com.zeroc.Ice.Router._iceD_getServerProxy(this, in, current);
            }
            case 8:
            {
                return _iceD_getSessionTimeout(this, in, current);
            }
            case 9:
            {
                return com.zeroc.Ice.Object._iceD_ice_id(this, in, current);
            }
            case 10:
            {
                return com.zeroc.Ice.Object._iceD_ice_ids(this, in, current);
            }
            case 11:
            {
                return com.zeroc.Ice.Object._iceD_ice_isA(this, in, current);
            }
            case 12:
            {
                return com.zeroc.Ice.Object._iceD_ice_ping(this, in, current);
            }
            case 13:
            {
                return _iceD_refreshSession(this, in, current);
            }
        }

        assert(false);
        throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
    }
}
