//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.9
//
// <auto-generated>
//
// Generated from file `Session.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Glacier2;

/**
 * The session manager for username/password authenticated users that
 * is responsible for managing {@link Session} objects. New session objects
 * are created by the {@link Router} object calling on an application-provided
 * session manager. If no session manager is provided by the application,
 * no client-visible sessions are passed to the client.
 *
 * @see Router
 * @see Session
 **/
public interface SessionManagerPrx extends com.zeroc.Ice.ObjectPrx
{
    /**
     * Create a new session.
     * @param userId The user id for the session.
     * @param control A proxy to the session control object.
     * @return A proxy to the newly created session.
     * @throws CannotCreateSessionException Raised if the session
     * cannot be created.
     **/
    default SessionPrx create(String userId, SessionControlPrx control)
        throws CannotCreateSessionException
    {
        return create(userId, control, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Create a new session.
     * @param userId The user id for the session.
     * @param control A proxy to the session control object.
     * @param context The Context map to send with the invocation.
     * @return A proxy to the newly created session.
     * @throws CannotCreateSessionException Raised if the session
     * cannot be created.
     **/
    default SessionPrx create(String userId, SessionControlPrx control, java.util.Map<String, String> context)
        throws CannotCreateSessionException
    {
        try
        {
            return _iceI_createAsync(userId, control, context, true).waitForResponseOrUserEx();
        }
        catch(CannotCreateSessionException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Create a new session.
     * @param userId The user id for the session.
     * @param control A proxy to the session control object.
     * @return A proxy to the newly created session.
     **/
    default java.util.concurrent.CompletableFuture<SessionPrx> createAsync(String userId, SessionControlPrx control)
    {
        return _iceI_createAsync(userId, control, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Create a new session.
     * @param userId The user id for the session.
     * @param control A proxy to the session control object.
     * @param context The Context map to send with the invocation.
     * @return A proxy to the newly created session.
     **/
    default java.util.concurrent.CompletableFuture<SessionPrx> createAsync(String userId, SessionControlPrx control, java.util.Map<String, String> context)
    {
        return _iceI_createAsync(userId, control, context, false);
    }

    /**
     * @hidden
     * @param iceP_userId -
     * @param iceP_control -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<SessionPrx> _iceI_createAsync(String iceP_userId, SessionControlPrx iceP_control, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<SessionPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "create", null, sync, _iceE_create);
        f.invoke(true, context, com.zeroc.Ice.FormatType.SlicedFormat, ostr -> {
                     ostr.writeString(iceP_userId);
                     ostr.writeProxy(iceP_control);
                 }, istr -> {
                     SessionPrx ret;
                     ret = SessionPrx.uncheckedCast(istr.readProxy());
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_create =
    {
        CannotCreateSessionException.class
    };

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static SessionManagerPrx checkedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, ice_staticId(), SessionManagerPrx.class, _SessionManagerPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static SessionManagerPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, context, ice_staticId(), SessionManagerPrx.class, _SessionManagerPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static SessionManagerPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, ice_staticId(), SessionManagerPrx.class, _SessionManagerPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static SessionManagerPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), SessionManagerPrx.class, _SessionManagerPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static SessionManagerPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, SessionManagerPrx.class, _SessionManagerPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static SessionManagerPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, facet, SessionManagerPrx.class, _SessionManagerPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default SessionManagerPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (SessionManagerPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default SessionManagerPrx ice_adapterId(String newAdapterId)
    {
        return (SessionManagerPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default SessionManagerPrx ice_endpoints(com.zeroc.Ice.Endpoint[] newEndpoints)
    {
        return (SessionManagerPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default SessionManagerPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (SessionManagerPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default SessionManagerPrx ice_invocationTimeout(int newTimeout)
    {
        return (SessionManagerPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default SessionManagerPrx ice_connectionCached(boolean newCache)
    {
        return (SessionManagerPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default SessionManagerPrx ice_endpointSelection(com.zeroc.Ice.EndpointSelectionType newType)
    {
        return (SessionManagerPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default SessionManagerPrx ice_secure(boolean b)
    {
        return (SessionManagerPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default SessionManagerPrx ice_encodingVersion(com.zeroc.Ice.EncodingVersion e)
    {
        return (SessionManagerPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default SessionManagerPrx ice_preferSecure(boolean b)
    {
        return (SessionManagerPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default SessionManagerPrx ice_router(com.zeroc.Ice.RouterPrx router)
    {
        return (SessionManagerPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default SessionManagerPrx ice_locator(com.zeroc.Ice.LocatorPrx locator)
    {
        return (SessionManagerPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default SessionManagerPrx ice_collocationOptimized(boolean b)
    {
        return (SessionManagerPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default SessionManagerPrx ice_twoway()
    {
        return (SessionManagerPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default SessionManagerPrx ice_oneway()
    {
        return (SessionManagerPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default SessionManagerPrx ice_batchOneway()
    {
        return (SessionManagerPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default SessionManagerPrx ice_datagram()
    {
        return (SessionManagerPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default SessionManagerPrx ice_batchDatagram()
    {
        return (SessionManagerPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default SessionManagerPrx ice_compress(boolean co)
    {
        return (SessionManagerPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default SessionManagerPrx ice_timeout(int t)
    {
        return (SessionManagerPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default SessionManagerPrx ice_connectionId(String connectionId)
    {
        return (SessionManagerPrx)_ice_connectionId(connectionId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except it's a fixed proxy bound
     * the given connection.@param connection The fixed proxy connection.
     * @return A fixed proxy bound to the given connection.
     **/
    @Override
    default SessionManagerPrx ice_fixed(com.zeroc.Ice.Connection connection)
    {
        return (SessionManagerPrx)_ice_fixed(connection);
    }

    static String ice_staticId()
    {
        return "::Glacier2::SessionManager";
    }
}
