//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.9
//
// <auto-generated>
//
// Generated from file `RemoteLogger.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Ice;

/**
 * The interface of the admin object that allows an Ice application the attach its
 * {@link RemoteLogger} to the {@link Logger} of this admin object's Ice communicator.
 **/
public interface LoggerAdminPrx extends ObjectPrx
{
    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     * @param prx A proxy to the remote logger.
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     * @throws RemoteLoggerAlreadyAttachedException Raised if this remote logger is already
     * attached to this admin object.
     **/
    default void attachRemoteLogger(RemoteLoggerPrx prx, LogMessageType[] messageTypes, String[] traceCategories, int messageMax)
        throws RemoteLoggerAlreadyAttachedException
    {
        attachRemoteLogger(prx, messageTypes, traceCategories, messageMax, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     * @param prx A proxy to the remote logger.
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     * @param context The Context map to send with the invocation.
     * @throws RemoteLoggerAlreadyAttachedException Raised if this remote logger is already
     * attached to this admin object.
     **/
    default void attachRemoteLogger(RemoteLoggerPrx prx, LogMessageType[] messageTypes, String[] traceCategories, int messageMax, java.util.Map<String, String> context)
        throws RemoteLoggerAlreadyAttachedException
    {
        try
        {
            _iceI_attachRemoteLoggerAsync(prx, messageTypes, traceCategories, messageMax, context, true).waitForResponseOrUserEx();
        }
        catch(RemoteLoggerAlreadyAttachedException ex)
        {
            throw ex;
        }
        catch(UserException ex)
        {
            throw new UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     * @param prx A proxy to the remote logger.
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> attachRemoteLoggerAsync(RemoteLoggerPrx prx, LogMessageType[] messageTypes, String[] traceCategories, int messageMax)
    {
        return _iceI_attachRemoteLoggerAsync(prx, messageTypes, traceCategories, messageMax, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     * @param prx A proxy to the remote logger.
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> attachRemoteLoggerAsync(RemoteLoggerPrx prx, LogMessageType[] messageTypes, String[] traceCategories, int messageMax, java.util.Map<String, String> context)
    {
        return _iceI_attachRemoteLoggerAsync(prx, messageTypes, traceCategories, messageMax, context, false);
    }

    /**
     * @hidden
     * @param iceP_prx -
     * @param iceP_messageTypes -
     * @param iceP_traceCategories -
     * @param iceP_messageMax -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_attachRemoteLoggerAsync(RemoteLoggerPrx iceP_prx, LogMessageType[] iceP_messageTypes, String[] iceP_traceCategories, int iceP_messageMax, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "attachRemoteLogger", null, sync, _iceE_attachRemoteLogger);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeProxy(iceP_prx);
                     LogMessageTypeSeqHelper.write(ostr, iceP_messageTypes);
                     ostr.writeStringSeq(iceP_traceCategories);
                     ostr.writeInt(iceP_messageMax);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_attachRemoteLogger =
    {
        RemoteLoggerAlreadyAttachedException.class
    };

    /**
     * Detaches a RemoteLogger object from the local logger.
     * @param prx A proxy to the remote logger.
     * @return True if the provided remote logger proxy was detached, and false otherwise.
     **/
    default boolean detachRemoteLogger(RemoteLoggerPrx prx)
    {
        return detachRemoteLogger(prx, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Detaches a RemoteLogger object from the local logger.
     * @param prx A proxy to the remote logger.
     * @param context The Context map to send with the invocation.
     * @return True if the provided remote logger proxy was detached, and false otherwise.
     **/
    default boolean detachRemoteLogger(RemoteLoggerPrx prx, java.util.Map<String, String> context)
    {
        return _iceI_detachRemoteLoggerAsync(prx, context, true).waitForResponse();
    }

    /**
     * Detaches a RemoteLogger object from the local logger.
     * @param prx A proxy to the remote logger.
     * @return True if the provided remote logger proxy was detached, and false otherwise.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Boolean> detachRemoteLoggerAsync(RemoteLoggerPrx prx)
    {
        return _iceI_detachRemoteLoggerAsync(prx, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Detaches a RemoteLogger object from the local logger.
     * @param prx A proxy to the remote logger.
     * @param context The Context map to send with the invocation.
     * @return True if the provided remote logger proxy was detached, and false otherwise.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Boolean> detachRemoteLoggerAsync(RemoteLoggerPrx prx, java.util.Map<String, String> context)
    {
        return _iceI_detachRemoteLoggerAsync(prx, context, false);
    }

    /**
     * @hidden
     * @param iceP_prx -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.lang.Boolean> _iceI_detachRemoteLoggerAsync(RemoteLoggerPrx iceP_prx, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.lang.Boolean> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "detachRemoteLogger", null, sync, null);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeProxy(iceP_prx);
                 }, istr -> {
                     boolean ret;
                     ret = istr.readBool();
                     return ret;
                 });
        return f;
    }

    /**
     * Retrieves log messages recently logged.
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     * @return An instance of LoggerAdmin.GetLogResult.
     **/
    default LoggerAdmin.GetLogResult getLog(LogMessageType[] messageTypes, String[] traceCategories, int messageMax)
    {
        return getLog(messageTypes, traceCategories, messageMax, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Retrieves log messages recently logged.
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     * @param context The Context map to send with the invocation.
     * @return An instance of LoggerAdmin.GetLogResult.
     **/
    default LoggerAdmin.GetLogResult getLog(LogMessageType[] messageTypes, String[] traceCategories, int messageMax, java.util.Map<String, String> context)
    {
        return _iceI_getLogAsync(messageTypes, traceCategories, messageMax, context, true).waitForResponse();
    }

    /**
     * Retrieves log messages recently logged.
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     * @return A future that will be completed with an instance of LoggerAdmin.GetLogResult.
     **/
    default java.util.concurrent.CompletableFuture<LoggerAdmin.GetLogResult> getLogAsync(LogMessageType[] messageTypes, String[] traceCategories, int messageMax)
    {
        return _iceI_getLogAsync(messageTypes, traceCategories, messageMax, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Retrieves log messages recently logged.
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed with an instance of LoggerAdmin.GetLogResult.
     **/
    default java.util.concurrent.CompletableFuture<LoggerAdmin.GetLogResult> getLogAsync(LogMessageType[] messageTypes, String[] traceCategories, int messageMax, java.util.Map<String, String> context)
    {
        return _iceI_getLogAsync(messageTypes, traceCategories, messageMax, context, false);
    }

    /**
     * @hidden
     * @param iceP_messageTypes -
     * @param iceP_traceCategories -
     * @param iceP_messageMax -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<LoggerAdmin.GetLogResult> _iceI_getLogAsync(LogMessageType[] iceP_messageTypes, String[] iceP_traceCategories, int iceP_messageMax, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<LoggerAdmin.GetLogResult> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getLog", null, sync, null);
        f.invoke(true, context, null, ostr -> {
                     LogMessageTypeSeqHelper.write(ostr, iceP_messageTypes);
                     ostr.writeStringSeq(iceP_traceCategories);
                     ostr.writeInt(iceP_messageMax);
                 }, istr -> {
                     LoggerAdmin.GetLogResult ret = new LoggerAdmin.GetLogResult();
                     ret.read(istr);
                     return ret;
                 });
        return f;
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static LoggerAdminPrx checkedCast(ObjectPrx obj)
    {
        return ObjectPrx._checkedCast(obj, ice_staticId(), LoggerAdminPrx.class, _LoggerAdminPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static LoggerAdminPrx checkedCast(ObjectPrx obj, java.util.Map<String, String> context)
    {
        return ObjectPrx._checkedCast(obj, context, ice_staticId(), LoggerAdminPrx.class, _LoggerAdminPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static LoggerAdminPrx checkedCast(ObjectPrx obj, String facet)
    {
        return ObjectPrx._checkedCast(obj, facet, ice_staticId(), LoggerAdminPrx.class, _LoggerAdminPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static LoggerAdminPrx checkedCast(ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), LoggerAdminPrx.class, _LoggerAdminPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static LoggerAdminPrx uncheckedCast(ObjectPrx obj)
    {
        return ObjectPrx._uncheckedCast(obj, LoggerAdminPrx.class, _LoggerAdminPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static LoggerAdminPrx uncheckedCast(ObjectPrx obj, String facet)
    {
        return ObjectPrx._uncheckedCast(obj, facet, LoggerAdminPrx.class, _LoggerAdminPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default LoggerAdminPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (LoggerAdminPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default LoggerAdminPrx ice_adapterId(String newAdapterId)
    {
        return (LoggerAdminPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default LoggerAdminPrx ice_endpoints(Endpoint[] newEndpoints)
    {
        return (LoggerAdminPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default LoggerAdminPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (LoggerAdminPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default LoggerAdminPrx ice_invocationTimeout(int newTimeout)
    {
        return (LoggerAdminPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default LoggerAdminPrx ice_connectionCached(boolean newCache)
    {
        return (LoggerAdminPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default LoggerAdminPrx ice_endpointSelection(EndpointSelectionType newType)
    {
        return (LoggerAdminPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default LoggerAdminPrx ice_secure(boolean b)
    {
        return (LoggerAdminPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default LoggerAdminPrx ice_encodingVersion(EncodingVersion e)
    {
        return (LoggerAdminPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default LoggerAdminPrx ice_preferSecure(boolean b)
    {
        return (LoggerAdminPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default LoggerAdminPrx ice_router(RouterPrx router)
    {
        return (LoggerAdminPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default LoggerAdminPrx ice_locator(LocatorPrx locator)
    {
        return (LoggerAdminPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default LoggerAdminPrx ice_collocationOptimized(boolean b)
    {
        return (LoggerAdminPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default LoggerAdminPrx ice_twoway()
    {
        return (LoggerAdminPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default LoggerAdminPrx ice_oneway()
    {
        return (LoggerAdminPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default LoggerAdminPrx ice_batchOneway()
    {
        return (LoggerAdminPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default LoggerAdminPrx ice_datagram()
    {
        return (LoggerAdminPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default LoggerAdminPrx ice_batchDatagram()
    {
        return (LoggerAdminPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default LoggerAdminPrx ice_compress(boolean co)
    {
        return (LoggerAdminPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default LoggerAdminPrx ice_timeout(int t)
    {
        return (LoggerAdminPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default LoggerAdminPrx ice_connectionId(String connectionId)
    {
        return (LoggerAdminPrx)_ice_connectionId(connectionId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except it's a fixed proxy bound
     * the given connection.@param connection The fixed proxy connection.
     * @return A fixed proxy bound to the given connection.
     **/
    @Override
    default LoggerAdminPrx ice_fixed(com.zeroc.Ice.Connection connection)
    {
        return (LoggerAdminPrx)_ice_fixed(connection);
    }

    static String ice_staticId()
    {
        return "::Ice::LoggerAdmin";
    }
}
