//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.9
//
// <auto-generated>
//
// Generated from file `Current.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Ice;

/**
 * Determines the retry behavior an invocation in case of a (potentially) recoverable error.
 **/
public enum OperationMode implements java.io.Serializable
{
    /**
     * Ordinary operations have <code>Normal</code> mode.  These operations
     * modify object state; invoking such an operation twice in a row
     * has different semantics than invoking it once. The Ice run time
     * guarantees that it will not violate at-most-once semantics for
     * <code>Normal</code> operations.
     **/
    Normal(0),
    /**
     * Operations that use the Slice <code>nonmutating</code> keyword must not
     * modify object state. For C++, nonmutating operations generate
     * <code>const</code> member functions in the skeleton. In addition, the Ice
     * run time will attempt to transparently recover from certain
     * run-time errors by re-issuing a failed request and propagate
     * the failure to the application only if the second attempt
     * fails.
     *
     * <p class="Deprecated"><code>Nonmutating</code> is deprecated; Use the
     * <code>idempotent</code> keyword instead. For C++, to retain the mapping
     * of <code>nonmutating</code> operations to C++ <code>const</code>
     * member functions, use the <code>\["cpp:const"]</code> metadata
     * directive.
     **/
    Nonmutating(1),
    /**
     * Operations that use the Slice <code>idempotent</code> keyword can modify
     * object state, but invoking an operation twice in a row must
     * result in the same object state as invoking it once.  For
     * example, <code>x = 1</code> is an idempotent statement,
     * whereas <code>x += 1</code> is not. For idempotent
     * operations, the Ice run-time uses the same retry behavior
     * as for nonmutating operations in case of a potentially
     * recoverable error.
     **/
    Idempotent(2);

    public int value()
    {
        return _value;
    }

    public static OperationMode valueOf(int v)
    {
        switch(v)
        {
        case 0:
            return Normal;
        case 1:
            return Nonmutating;
        case 2:
            return Idempotent;
        }
        return null;
    }

    private OperationMode(int v)
    {
        _value = v;
    }

    public void ice_write(OutputStream ostr)
    {
        ostr.writeEnum(_value, 2);
    }

    public static void ice_write(OutputStream ostr, OperationMode v)
    {
        if(v == null)
        {
            ostr.writeEnum(com.zeroc.Ice.OperationMode.Normal.value(), 2);
        }
        else
        {
            ostr.writeEnum(v.value(), 2);
        }
    }

    public static OperationMode ice_read(InputStream istr)
    {
        int v = istr.readEnum(2);
        return validate(v);
    }

    public static void ice_write(OutputStream ostr, int tag, java.util.Optional<OperationMode> v)
    {
        if(v != null && v.isPresent())
        {
            ice_write(ostr, tag, v.get());
        }
    }

    public static void ice_write(OutputStream ostr, int tag, OperationMode v)
    {
        if(ostr.writeOptional(tag, com.zeroc.Ice.OptionalFormat.Size))
        {
            ice_write(ostr, v);
        }
    }

    public static java.util.Optional<OperationMode> ice_read(InputStream istr, int tag)
    {
        if(istr.readOptional(tag, com.zeroc.Ice.OptionalFormat.Size))
        {
            return java.util.Optional.of(ice_read(istr));
        }
        else
        {
            return java.util.Optional.empty();
        }
    }

    private static OperationMode validate(int v)
    {
        final OperationMode e = valueOf(v);
        if(e == null)
        {
            throw new MarshalException("enumerator value " + v + " is out of range");
        }
        return e;
    }

    private final int _value;
}
