//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.9
//
// <auto-generated>
//
// Generated from file `RemoteLogger.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Ice;

/**
 * The Ice remote logger interface. An application can implement a
 * RemoteLogger to receive the log messages sent to the local {@link Logger}
 * of another Ice application.
 **/
public interface RemoteLogger extends Object
{
    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     * @param prefix The prefix of the associated local Logger.
     * @param logMessages Old log messages generated before "now".
     * @param current The Current object for the invocation.
     **/
    void init(String prefix, LogMessage[] logMessages, Current current);

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     * @param message The message to log.
     * @param current The Current object for the invocation.
     **/
    void log(LogMessage message, Current current);

    /** @hidden */
    static final String[] _iceIds =
    {
        "::Ice::Object",
        "::Ice::RemoteLogger"
    };

    @Override
    default String[] ice_ids(Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::Ice::RemoteLogger";
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<OutputStream> _iceD_init(RemoteLogger obj, final com.zeroc.IceInternal.Incoming inS, Current current)
    {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_prefix;
        LogMessage[] iceP_logMessages;
        iceP_prefix = istr.readString();
        iceP_logMessages = LogMessageSeqHelper.read(istr);
        inS.endReadParams();
        obj.init(iceP_prefix, iceP_logMessages, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<OutputStream> _iceD_log(RemoteLogger obj, final com.zeroc.IceInternal.Incoming inS, Current current)
    {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        LogMessage iceP_message;
        iceP_message = LogMessage.ice_read(istr);
        inS.endReadParams();
        obj.log(iceP_message, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /** @hidden */
    final static String[] _iceOps =
    {
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping",
        "init",
        "log"
    };

    /** @hidden */
    @Override
    default java.util.concurrent.CompletionStage<OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, Current current)
        throws UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return Object._iceD_ice_id(this, in, current);
            }
            case 1:
            {
                return Object._iceD_ice_ids(this, in, current);
            }
            case 2:
            {
                return Object._iceD_ice_isA(this, in, current);
            }
            case 3:
            {
                return Object._iceD_ice_ping(this, in, current);
            }
            case 4:
            {
                return _iceD_init(this, in, current);
            }
            case 5:
            {
                return _iceD_log(this, in, current);
            }
        }

        assert(false);
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }
}
