//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.9
//
// <auto-generated>
//
// Generated from file `Metrics.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceMX;

/**
 * The metrics administrative facet interface. This interface allows
 * remote administrative clients to access metrics of an application
 * that enabled the Ice administrative facility and configured some
 * metrics views.
 **/
public interface MetricsAdminPrx extends com.zeroc.Ice.ObjectPrx
{
    /**
     * Get the names of enabled and disabled metrics.
     * @return An instance of MetricsAdmin.GetMetricsViewNamesResult.
     **/
    default MetricsAdmin.GetMetricsViewNamesResult getMetricsViewNames()
    {
        return getMetricsViewNames(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the names of enabled and disabled metrics.
     * @param context The Context map to send with the invocation.
     * @return An instance of MetricsAdmin.GetMetricsViewNamesResult.
     **/
    default MetricsAdmin.GetMetricsViewNamesResult getMetricsViewNames(java.util.Map<String, String> context)
    {
        return _iceI_getMetricsViewNamesAsync(context, true).waitForResponse();
    }

    /**
     * Get the names of enabled and disabled metrics.
     * @return A future that will be completed with an instance of MetricsAdmin.GetMetricsViewNamesResult.
     **/
    default java.util.concurrent.CompletableFuture<MetricsAdmin.GetMetricsViewNamesResult> getMetricsViewNamesAsync()
    {
        return _iceI_getMetricsViewNamesAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the names of enabled and disabled metrics.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed with an instance of MetricsAdmin.GetMetricsViewNamesResult.
     **/
    default java.util.concurrent.CompletableFuture<MetricsAdmin.GetMetricsViewNamesResult> getMetricsViewNamesAsync(java.util.Map<String, String> context)
    {
        return _iceI_getMetricsViewNamesAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<MetricsAdmin.GetMetricsViewNamesResult> _iceI_getMetricsViewNamesAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<MetricsAdmin.GetMetricsViewNamesResult> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getMetricsViewNames", null, sync, null);
        f.invoke(true, context, com.zeroc.Ice.FormatType.SlicedFormat, null, istr -> {
                     MetricsAdmin.GetMetricsViewNamesResult ret = new MetricsAdmin.GetMetricsViewNamesResult();
                     ret.read(istr);
                     return ret;
                 });
        return f;
    }

    /**
     * Enables a metrics view.
     * @param name The metrics view name.
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     **/
    default void enableMetricsView(String name)
        throws UnknownMetricsView
    {
        enableMetricsView(name, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Enables a metrics view.
     * @param name The metrics view name.
     * @param context The Context map to send with the invocation.
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     **/
    default void enableMetricsView(String name, java.util.Map<String, String> context)
        throws UnknownMetricsView
    {
        try
        {
            _iceI_enableMetricsViewAsync(name, context, true).waitForResponseOrUserEx();
        }
        catch(UnknownMetricsView ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Enables a metrics view.
     * @param name The metrics view name.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> enableMetricsViewAsync(String name)
    {
        return _iceI_enableMetricsViewAsync(name, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Enables a metrics view.
     * @param name The metrics view name.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> enableMetricsViewAsync(String name, java.util.Map<String, String> context)
    {
        return _iceI_enableMetricsViewAsync(name, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_enableMetricsViewAsync(String iceP_name, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "enableMetricsView", null, sync, _iceE_enableMetricsView);
        f.invoke(true, context, com.zeroc.Ice.FormatType.SlicedFormat, ostr -> {
                     ostr.writeString(iceP_name);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_enableMetricsView =
    {
        UnknownMetricsView.class
    };

    /**
     * Disable a metrics view.
     * @param name The metrics view name.
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     **/
    default void disableMetricsView(String name)
        throws UnknownMetricsView
    {
        disableMetricsView(name, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Disable a metrics view.
     * @param name The metrics view name.
     * @param context The Context map to send with the invocation.
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     **/
    default void disableMetricsView(String name, java.util.Map<String, String> context)
        throws UnknownMetricsView
    {
        try
        {
            _iceI_disableMetricsViewAsync(name, context, true).waitForResponseOrUserEx();
        }
        catch(UnknownMetricsView ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Disable a metrics view.
     * @param name The metrics view name.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> disableMetricsViewAsync(String name)
    {
        return _iceI_disableMetricsViewAsync(name, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Disable a metrics view.
     * @param name The metrics view name.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> disableMetricsViewAsync(String name, java.util.Map<String, String> context)
    {
        return _iceI_disableMetricsViewAsync(name, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_disableMetricsViewAsync(String iceP_name, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "disableMetricsView", null, sync, _iceE_disableMetricsView);
        f.invoke(true, context, com.zeroc.Ice.FormatType.SlicedFormat, ostr -> {
                     ostr.writeString(iceP_name);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_disableMetricsView =
    {
        UnknownMetricsView.class
    };

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * @param view The name of the metrics view.
     * @return An instance of MetricsAdmin.GetMetricsViewResult.
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     **/
    default MetricsAdmin.GetMetricsViewResult getMetricsView(String view)
        throws UnknownMetricsView
    {
        return getMetricsView(view, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * @param view The name of the metrics view.
     * @param context The Context map to send with the invocation.
     * @return An instance of MetricsAdmin.GetMetricsViewResult.
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     **/
    default MetricsAdmin.GetMetricsViewResult getMetricsView(String view, java.util.Map<String, String> context)
        throws UnknownMetricsView
    {
        try
        {
            return _iceI_getMetricsViewAsync(view, context, true).waitForResponseOrUserEx();
        }
        catch(UnknownMetricsView ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * @param view The name of the metrics view.
     * @return A future that will be completed with an instance of MetricsAdmin.GetMetricsViewResult.
     **/
    default java.util.concurrent.CompletableFuture<MetricsAdmin.GetMetricsViewResult> getMetricsViewAsync(String view)
    {
        return _iceI_getMetricsViewAsync(view, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * @param view The name of the metrics view.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed with an instance of MetricsAdmin.GetMetricsViewResult.
     **/
    default java.util.concurrent.CompletableFuture<MetricsAdmin.GetMetricsViewResult> getMetricsViewAsync(String view, java.util.Map<String, String> context)
    {
        return _iceI_getMetricsViewAsync(view, context, false);
    }

    /**
     * @hidden
     * @param iceP_view -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<MetricsAdmin.GetMetricsViewResult> _iceI_getMetricsViewAsync(String iceP_view, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<MetricsAdmin.GetMetricsViewResult> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getMetricsView", null, sync, _iceE_getMetricsView);
        f.invoke(true, context, com.zeroc.Ice.FormatType.SlicedFormat, ostr -> {
                     ostr.writeString(iceP_view);
                 }, istr -> {
                     MetricsAdmin.GetMetricsViewResult ret = new MetricsAdmin.GetMetricsViewResult();
                     ret.read(istr);
                     istr.readPendingValues();
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_getMetricsView =
    {
        UnknownMetricsView.class
    };

    /**
     * Get the metrics failures associated with the given view and map.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @return The metrics failures associated with the map.
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     **/
    default MetricsFailures[] getMapMetricsFailures(String view, String map)
        throws UnknownMetricsView
    {
        return getMapMetricsFailures(view, map, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the metrics failures associated with the given view and map.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param context The Context map to send with the invocation.
     * @return The metrics failures associated with the map.
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     **/
    default MetricsFailures[] getMapMetricsFailures(String view, String map, java.util.Map<String, String> context)
        throws UnknownMetricsView
    {
        try
        {
            return _iceI_getMapMetricsFailuresAsync(view, map, context, true).waitForResponseOrUserEx();
        }
        catch(UnknownMetricsView ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Get the metrics failures associated with the given view and map.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @return The metrics failures associated with the map.
     **/
    default java.util.concurrent.CompletableFuture<MetricsFailures[]> getMapMetricsFailuresAsync(String view, String map)
    {
        return _iceI_getMapMetricsFailuresAsync(view, map, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the metrics failures associated with the given view and map.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param context The Context map to send with the invocation.
     * @return The metrics failures associated with the map.
     **/
    default java.util.concurrent.CompletableFuture<MetricsFailures[]> getMapMetricsFailuresAsync(String view, String map, java.util.Map<String, String> context)
    {
        return _iceI_getMapMetricsFailuresAsync(view, map, context, false);
    }

    /**
     * @hidden
     * @param iceP_view -
     * @param iceP_map -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<MetricsFailures[]> _iceI_getMapMetricsFailuresAsync(String iceP_view, String iceP_map, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<MetricsFailures[]> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getMapMetricsFailures", null, sync, _iceE_getMapMetricsFailures);
        f.invoke(true, context, com.zeroc.Ice.FormatType.SlicedFormat, ostr -> {
                     ostr.writeString(iceP_view);
                     ostr.writeString(iceP_map);
                 }, istr -> {
                     MetricsFailures[] ret;
                     ret = MetricsFailuresSeqHelper.read(istr);
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_getMapMetricsFailures =
    {
        UnknownMetricsView.class
    };

    /**
     * Get the metrics failure associated for the given metrics.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param id The ID of the metrics.
     * @return The metrics failures associated with the metrics.
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     **/
    default MetricsFailures getMetricsFailures(String view, String map, String id)
        throws UnknownMetricsView
    {
        return getMetricsFailures(view, map, id, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the metrics failure associated for the given metrics.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param id The ID of the metrics.
     * @param context The Context map to send with the invocation.
     * @return The metrics failures associated with the metrics.
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     **/
    default MetricsFailures getMetricsFailures(String view, String map, String id, java.util.Map<String, String> context)
        throws UnknownMetricsView
    {
        try
        {
            return _iceI_getMetricsFailuresAsync(view, map, id, context, true).waitForResponseOrUserEx();
        }
        catch(UnknownMetricsView ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Get the metrics failure associated for the given metrics.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param id The ID of the metrics.
     * @return The metrics failures associated with the metrics.
     **/
    default java.util.concurrent.CompletableFuture<MetricsFailures> getMetricsFailuresAsync(String view, String map, String id)
    {
        return _iceI_getMetricsFailuresAsync(view, map, id, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the metrics failure associated for the given metrics.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param id The ID of the metrics.
     * @param context The Context map to send with the invocation.
     * @return The metrics failures associated with the metrics.
     **/
    default java.util.concurrent.CompletableFuture<MetricsFailures> getMetricsFailuresAsync(String view, String map, String id, java.util.Map<String, String> context)
    {
        return _iceI_getMetricsFailuresAsync(view, map, id, context, false);
    }

    /**
     * @hidden
     * @param iceP_view -
     * @param iceP_map -
     * @param iceP_id -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<MetricsFailures> _iceI_getMetricsFailuresAsync(String iceP_view, String iceP_map, String iceP_id, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<MetricsFailures> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getMetricsFailures", null, sync, _iceE_getMetricsFailures);
        f.invoke(true, context, com.zeroc.Ice.FormatType.SlicedFormat, ostr -> {
                     ostr.writeString(iceP_view);
                     ostr.writeString(iceP_map);
                     ostr.writeString(iceP_id);
                 }, istr -> {
                     MetricsFailures ret;
                     ret = MetricsFailures.ice_read(istr);
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_getMetricsFailures =
    {
        UnknownMetricsView.class
    };

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static MetricsAdminPrx checkedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, ice_staticId(), MetricsAdminPrx.class, _MetricsAdminPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static MetricsAdminPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, context, ice_staticId(), MetricsAdminPrx.class, _MetricsAdminPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static MetricsAdminPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, ice_staticId(), MetricsAdminPrx.class, _MetricsAdminPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static MetricsAdminPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), MetricsAdminPrx.class, _MetricsAdminPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static MetricsAdminPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, MetricsAdminPrx.class, _MetricsAdminPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static MetricsAdminPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, facet, MetricsAdminPrx.class, _MetricsAdminPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default MetricsAdminPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (MetricsAdminPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default MetricsAdminPrx ice_adapterId(String newAdapterId)
    {
        return (MetricsAdminPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default MetricsAdminPrx ice_endpoints(com.zeroc.Ice.Endpoint[] newEndpoints)
    {
        return (MetricsAdminPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default MetricsAdminPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (MetricsAdminPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default MetricsAdminPrx ice_invocationTimeout(int newTimeout)
    {
        return (MetricsAdminPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default MetricsAdminPrx ice_connectionCached(boolean newCache)
    {
        return (MetricsAdminPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default MetricsAdminPrx ice_endpointSelection(com.zeroc.Ice.EndpointSelectionType newType)
    {
        return (MetricsAdminPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default MetricsAdminPrx ice_secure(boolean b)
    {
        return (MetricsAdminPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default MetricsAdminPrx ice_encodingVersion(com.zeroc.Ice.EncodingVersion e)
    {
        return (MetricsAdminPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default MetricsAdminPrx ice_preferSecure(boolean b)
    {
        return (MetricsAdminPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default MetricsAdminPrx ice_router(com.zeroc.Ice.RouterPrx router)
    {
        return (MetricsAdminPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default MetricsAdminPrx ice_locator(com.zeroc.Ice.LocatorPrx locator)
    {
        return (MetricsAdminPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default MetricsAdminPrx ice_collocationOptimized(boolean b)
    {
        return (MetricsAdminPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default MetricsAdminPrx ice_twoway()
    {
        return (MetricsAdminPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default MetricsAdminPrx ice_oneway()
    {
        return (MetricsAdminPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default MetricsAdminPrx ice_batchOneway()
    {
        return (MetricsAdminPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default MetricsAdminPrx ice_datagram()
    {
        return (MetricsAdminPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default MetricsAdminPrx ice_batchDatagram()
    {
        return (MetricsAdminPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default MetricsAdminPrx ice_compress(boolean co)
    {
        return (MetricsAdminPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default MetricsAdminPrx ice_timeout(int t)
    {
        return (MetricsAdminPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default MetricsAdminPrx ice_connectionId(String connectionId)
    {
        return (MetricsAdminPrx)_ice_connectionId(connectionId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except it's a fixed proxy bound
     * the given connection.@param connection The fixed proxy connection.
     * @return A fixed proxy bound to the given connection.
     **/
    @Override
    default MetricsAdminPrx ice_fixed(com.zeroc.Ice.Connection connection)
    {
        return (MetricsAdminPrx)_ice_fixed(connection);
    }

    static String ice_staticId()
    {
        return "::IceMX::MetricsAdmin";
    }
}
