//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.9
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceGrid;

/**
 * This interface allows applications to monitor IceGrid well-known objects.
 **/
public interface ObjectObserver extends com.zeroc.Ice.Object
{
    /**
     * <code>objectInit</code> is called after the registration of
     * an observer to indicate the state of the registry.
     * @param objects The objects registered with the {@link Admin}
     * interface (not through the deployment mechanism).
     * @param current The Current object for the invocation.
     **/
    void objectInit(ObjectInfo[] objects, com.zeroc.Ice.Current current);

    /**
     * The <code>objectAdded</code> operation is called to notify an observer when an
     * object was added to the {@link Admin} interface.
     * @param info The details of the added object.
     * @param current The Current object for the invocation.
     **/
    void objectAdded(ObjectInfo info, com.zeroc.Ice.Current current);

    /**
     * <code>objectUpdated</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was updated.
     * @param info The details of the updated object.
     * @param current The Current object for the invocation.
     **/
    void objectUpdated(ObjectInfo info, com.zeroc.Ice.Current current);

    /**
     * <code>objectRemoved</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was removed.
     * @param id The identity of the removed object.
     * @param current The Current object for the invocation.
     **/
    void objectRemoved(com.zeroc.Ice.Identity id, com.zeroc.Ice.Current current);

    /** @hidden */
    static final String[] _iceIds =
    {
        "::Ice::Object",
        "::IceGrid::ObjectObserver"
    };

    @Override
    default String[] ice_ids(com.zeroc.Ice.Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(com.zeroc.Ice.Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::IceGrid::ObjectObserver";
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_objectInit(ObjectObserver obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        ObjectInfo[] iceP_objects;
        iceP_objects = ObjectInfoSeqHelper.read(istr);
        inS.endReadParams();
        obj.objectInit(iceP_objects, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_objectAdded(ObjectObserver obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        ObjectInfo iceP_info;
        iceP_info = ObjectInfo.ice_read(istr);
        inS.endReadParams();
        obj.objectAdded(iceP_info, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_objectUpdated(ObjectObserver obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        ObjectInfo iceP_info;
        iceP_info = ObjectInfo.ice_read(istr);
        inS.endReadParams();
        obj.objectUpdated(iceP_info, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_objectRemoved(ObjectObserver obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        com.zeroc.Ice.Identity iceP_id;
        iceP_id = com.zeroc.Ice.Identity.ice_read(istr);
        inS.endReadParams();
        obj.objectRemoved(iceP_id, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /** @hidden */
    final static String[] _iceOps =
    {
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping",
        "objectAdded",
        "objectInit",
        "objectRemoved",
        "objectUpdated"
    };

    /** @hidden */
    @Override
    default java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return com.zeroc.Ice.Object._iceD_ice_id(this, in, current);
            }
            case 1:
            {
                return com.zeroc.Ice.Object._iceD_ice_ids(this, in, current);
            }
            case 2:
            {
                return com.zeroc.Ice.Object._iceD_ice_isA(this, in, current);
            }
            case 3:
            {
                return com.zeroc.Ice.Object._iceD_ice_ping(this, in, current);
            }
            case 4:
            {
                return _iceD_objectAdded(this, in, current);
            }
            case 5:
            {
                return _iceD_objectInit(this, in, current);
            }
            case 6:
            {
                return _iceD_objectRemoved(this, in, current);
            }
            case 7:
            {
                return _iceD_objectUpdated(this, in, current);
            }
        }

        assert(false);
        throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
    }
}
