//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.9
//
// <auto-generated>
//
// Generated from file `Registry.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceGrid;

/**
 * The IceGrid registry allows clients create sessions
 * directly with the registry.
 *
 * @see Session
 * @see AdminSession
 **/
public interface RegistryPrx extends com.zeroc.Ice.ObjectPrx
{
    /**
     * Create a client session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @return A proxy for the newly created session.
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     **/
    default SessionPrx createSession(String userId, String password)
        throws PermissionDeniedException
    {
        return createSession(userId, password, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Create a client session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     **/
    default SessionPrx createSession(String userId, String password, java.util.Map<String, String> context)
        throws PermissionDeniedException
    {
        try
        {
            return _iceI_createSessionAsync(userId, password, context, true).waitForResponseOrUserEx();
        }
        catch(PermissionDeniedException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Create a client session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @return A proxy for the newly created session.
     **/
    default java.util.concurrent.CompletableFuture<SessionPrx> createSessionAsync(String userId, String password)
    {
        return _iceI_createSessionAsync(userId, password, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Create a client session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     **/
    default java.util.concurrent.CompletableFuture<SessionPrx> createSessionAsync(String userId, String password, java.util.Map<String, String> context)
    {
        return _iceI_createSessionAsync(userId, password, context, false);
    }

    /**
     * @hidden
     * @param iceP_userId -
     * @param iceP_password -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<SessionPrx> _iceI_createSessionAsync(String iceP_userId, String iceP_password, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<SessionPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "createSession", null, sync, _iceE_createSession);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_userId);
                     ostr.writeString(iceP_password);
                 }, istr -> {
                     SessionPrx ret;
                     ret = SessionPrx.uncheckedCast(istr.readProxy());
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_createSession =
    {
        PermissionDeniedException.class
    };

    /**
     * Create an administrative session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @return A proxy for the newly created session.
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     **/
    default AdminSessionPrx createAdminSession(String userId, String password)
        throws PermissionDeniedException
    {
        return createAdminSession(userId, password, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Create an administrative session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     **/
    default AdminSessionPrx createAdminSession(String userId, String password, java.util.Map<String, String> context)
        throws PermissionDeniedException
    {
        try
        {
            return _iceI_createAdminSessionAsync(userId, password, context, true).waitForResponseOrUserEx();
        }
        catch(PermissionDeniedException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Create an administrative session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @return A proxy for the newly created session.
     **/
    default java.util.concurrent.CompletableFuture<AdminSessionPrx> createAdminSessionAsync(String userId, String password)
    {
        return _iceI_createAdminSessionAsync(userId, password, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Create an administrative session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     **/
    default java.util.concurrent.CompletableFuture<AdminSessionPrx> createAdminSessionAsync(String userId, String password, java.util.Map<String, String> context)
    {
        return _iceI_createAdminSessionAsync(userId, password, context, false);
    }

    /**
     * @hidden
     * @param iceP_userId -
     * @param iceP_password -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<AdminSessionPrx> _iceI_createAdminSessionAsync(String iceP_userId, String iceP_password, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<AdminSessionPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "createAdminSession", null, sync, _iceE_createAdminSession);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_userId);
                     ostr.writeString(iceP_password);
                 }, istr -> {
                     AdminSessionPrx ret;
                     ret = AdminSessionPrx.uncheckedCast(istr.readProxy());
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_createAdminSession =
    {
        PermissionDeniedException.class
    };

    /**
     * Create a client session from a secure connection.
     * @return A proxy for the newly created session.
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     **/
    default SessionPrx createSessionFromSecureConnection()
        throws PermissionDeniedException
    {
        return createSessionFromSecureConnection(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Create a client session from a secure connection.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     **/
    default SessionPrx createSessionFromSecureConnection(java.util.Map<String, String> context)
        throws PermissionDeniedException
    {
        try
        {
            return _iceI_createSessionFromSecureConnectionAsync(context, true).waitForResponseOrUserEx();
        }
        catch(PermissionDeniedException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Create a client session from a secure connection.
     * @return A proxy for the newly created session.
     **/
    default java.util.concurrent.CompletableFuture<SessionPrx> createSessionFromSecureConnectionAsync()
    {
        return _iceI_createSessionFromSecureConnectionAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Create a client session from a secure connection.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     **/
    default java.util.concurrent.CompletableFuture<SessionPrx> createSessionFromSecureConnectionAsync(java.util.Map<String, String> context)
    {
        return _iceI_createSessionFromSecureConnectionAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<SessionPrx> _iceI_createSessionFromSecureConnectionAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<SessionPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "createSessionFromSecureConnection", null, sync, _iceE_createSessionFromSecureConnection);
        f.invoke(true, context, null, null, istr -> {
                     SessionPrx ret;
                     ret = SessionPrx.uncheckedCast(istr.readProxy());
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_createSessionFromSecureConnection =
    {
        PermissionDeniedException.class
    };

    /**
     * Create an administrative session from a secure connection.
     * @return A proxy for the newly created session.
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     **/
    default AdminSessionPrx createAdminSessionFromSecureConnection()
        throws PermissionDeniedException
    {
        return createAdminSessionFromSecureConnection(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Create an administrative session from a secure connection.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     **/
    default AdminSessionPrx createAdminSessionFromSecureConnection(java.util.Map<String, String> context)
        throws PermissionDeniedException
    {
        try
        {
            return _iceI_createAdminSessionFromSecureConnectionAsync(context, true).waitForResponseOrUserEx();
        }
        catch(PermissionDeniedException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Create an administrative session from a secure connection.
     * @return A proxy for the newly created session.
     **/
    default java.util.concurrent.CompletableFuture<AdminSessionPrx> createAdminSessionFromSecureConnectionAsync()
    {
        return _iceI_createAdminSessionFromSecureConnectionAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Create an administrative session from a secure connection.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     **/
    default java.util.concurrent.CompletableFuture<AdminSessionPrx> createAdminSessionFromSecureConnectionAsync(java.util.Map<String, String> context)
    {
        return _iceI_createAdminSessionFromSecureConnectionAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<AdminSessionPrx> _iceI_createAdminSessionFromSecureConnectionAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<AdminSessionPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "createAdminSessionFromSecureConnection", null, sync, _iceE_createAdminSessionFromSecureConnection);
        f.invoke(true, context, null, null, istr -> {
                     AdminSessionPrx ret;
                     ret = AdminSessionPrx.uncheckedCast(istr.readProxy());
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_createAdminSessionFromSecureConnection =
    {
        PermissionDeniedException.class
    };

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * @return The timeout (in seconds).
     *
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     **/
    default int getSessionTimeout()
    {
        return getSessionTimeout(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * @param context The Context map to send with the invocation.
     * @return The timeout (in seconds).
     *
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     **/
    default int getSessionTimeout(java.util.Map<String, String> context)
    {
        return _iceI_getSessionTimeoutAsync(context, true).waitForResponse();
    }

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * @return The timeout (in seconds).
     *
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Integer> getSessionTimeoutAsync()
    {
        return _iceI_getSessionTimeoutAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * @param context The Context map to send with the invocation.
     * @return The timeout (in seconds).
     *
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Integer> getSessionTimeoutAsync(java.util.Map<String, String> context)
    {
        return _iceI_getSessionTimeoutAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.lang.Integer> _iceI_getSessionTimeoutAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.lang.Integer> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getSessionTimeout", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     int ret;
                     ret = istr.readInt();
                     return ret;
                 });
        return f;
    }

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @return The timeout (in seconds).
     **/
    default int getACMTimeout()
    {
        return getACMTimeout(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param context The Context map to send with the invocation.
     * @return The timeout (in seconds).
     **/
    default int getACMTimeout(java.util.Map<String, String> context)
    {
        return _iceI_getACMTimeoutAsync(context, true).waitForResponse();
    }

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @return The timeout (in seconds).
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Integer> getACMTimeoutAsync()
    {
        return _iceI_getACMTimeoutAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param context The Context map to send with the invocation.
     * @return The timeout (in seconds).
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Integer> getACMTimeoutAsync(java.util.Map<String, String> context)
    {
        return _iceI_getACMTimeoutAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.lang.Integer> _iceI_getACMTimeoutAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.lang.Integer> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getACMTimeout", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     int ret;
                     ret = istr.readInt();
                     return ret;
                 });
        return f;
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static RegistryPrx checkedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, ice_staticId(), RegistryPrx.class, _RegistryPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static RegistryPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, context, ice_staticId(), RegistryPrx.class, _RegistryPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static RegistryPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, ice_staticId(), RegistryPrx.class, _RegistryPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static RegistryPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), RegistryPrx.class, _RegistryPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static RegistryPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, RegistryPrx.class, _RegistryPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static RegistryPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, facet, RegistryPrx.class, _RegistryPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default RegistryPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (RegistryPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default RegistryPrx ice_adapterId(String newAdapterId)
    {
        return (RegistryPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default RegistryPrx ice_endpoints(com.zeroc.Ice.Endpoint[] newEndpoints)
    {
        return (RegistryPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default RegistryPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (RegistryPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default RegistryPrx ice_invocationTimeout(int newTimeout)
    {
        return (RegistryPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default RegistryPrx ice_connectionCached(boolean newCache)
    {
        return (RegistryPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default RegistryPrx ice_endpointSelection(com.zeroc.Ice.EndpointSelectionType newType)
    {
        return (RegistryPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default RegistryPrx ice_secure(boolean b)
    {
        return (RegistryPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default RegistryPrx ice_encodingVersion(com.zeroc.Ice.EncodingVersion e)
    {
        return (RegistryPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default RegistryPrx ice_preferSecure(boolean b)
    {
        return (RegistryPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default RegistryPrx ice_router(com.zeroc.Ice.RouterPrx router)
    {
        return (RegistryPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default RegistryPrx ice_locator(com.zeroc.Ice.LocatorPrx locator)
    {
        return (RegistryPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default RegistryPrx ice_collocationOptimized(boolean b)
    {
        return (RegistryPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default RegistryPrx ice_twoway()
    {
        return (RegistryPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default RegistryPrx ice_oneway()
    {
        return (RegistryPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default RegistryPrx ice_batchOneway()
    {
        return (RegistryPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default RegistryPrx ice_datagram()
    {
        return (RegistryPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default RegistryPrx ice_batchDatagram()
    {
        return (RegistryPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default RegistryPrx ice_compress(boolean co)
    {
        return (RegistryPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default RegistryPrx ice_timeout(int t)
    {
        return (RegistryPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default RegistryPrx ice_connectionId(String connectionId)
    {
        return (RegistryPrx)_ice_connectionId(connectionId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except it's a fixed proxy bound
     * the given connection.@param connection The fixed proxy connection.
     * @return A fixed proxy bound to the given connection.
     **/
    @Override
    default RegistryPrx ice_fixed(com.zeroc.Ice.Connection connection)
    {
        return (RegistryPrx)_ice_fixed(connection);
    }

    static String ice_staticId()
    {
        return "::IceGrid::Registry";
    }
}
