//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.9
//
// <auto-generated>
//
// Generated from file `Session.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceGrid;

/**
 * A session object is used by IceGrid clients to allocate and
 * release objects. Client sessions are created either via the
 * {@link Registry} object or via the registry client <code>SessionManager</code>
 * object.
 *
 * @see Registry
 **/
public interface Session extends com.zeroc.Glacier2.Session
{
    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param current The Current object for the invocation.
     *
     * @see Registry#getSessionTimeout
     **/
    void keepAlive(com.zeroc.Ice.Current current);

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * @param id The identity of the object to allocate.
     * @param current The Current object for the invocation.
     * @return The proxy of the allocated object.
     * @throws AllocationException Raised if the object can't be
     * allocated.
     * @throws ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     *
     * @see #setAllocationTimeout
     * @see #releaseObject
     **/
    java.util.concurrent.CompletionStage<com.zeroc.Ice.ObjectPrx> allocateObjectByIdAsync(com.zeroc.Ice.Identity id, com.zeroc.Ice.Current current)
        throws AllocationException,
               ObjectNotRegisteredException;

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * @param type The type of the object.
     * @param current The Current object for the invocation.
     * @return The proxy of the allocated object.
     * @throws AllocationException Raised if the object could not be allocated.
     *
     * @see #setAllocationTimeout
     * @see #releaseObject
     **/
    java.util.concurrent.CompletionStage<com.zeroc.Ice.ObjectPrx> allocateObjectByTypeAsync(String type, com.zeroc.Ice.Current current)
        throws AllocationException;

    /**
     * Release an object that was allocated using <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code>.
     * @param id The identity of the object to release.
     * @param current The Current object for the invocation.
     * @throws AllocationException Raised if the given object can't be
     * released. This might happen if the object isn't allocatable or
     * isn't allocated by the session.
     * @throws ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     **/
    void releaseObject(com.zeroc.Ice.Identity id, com.zeroc.Ice.Current current)
        throws AllocationException,
               ObjectNotRegisteredException;

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code> will block for the duration of this
     * timeout.
     * @param timeout The timeout in milliseconds.
     * @param current The Current object for the invocation.
     **/
    void setAllocationTimeout(int timeout, com.zeroc.Ice.Current current);

    /** @hidden */
    static final String[] _iceIds =
    {
        "::Glacier2::Session",
        "::Ice::Object",
        "::IceGrid::Session"
    };

    @Override
    default String[] ice_ids(com.zeroc.Ice.Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(com.zeroc.Ice.Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::IceGrid::Session";
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_keepAlive(Session obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        obj.keepAlive(current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_allocateObjectById(Session obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        com.zeroc.Ice.Identity iceP_id;
        iceP_id = com.zeroc.Ice.Identity.ice_read(istr);
        inS.endReadParams();
        return inS.setResultFuture(obj.allocateObjectByIdAsync(iceP_id, current), (ostr, ret) ->
            {
                ostr.writeProxy(ret);
            });
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_allocateObjectByType(Session obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_type;
        iceP_type = istr.readString();
        inS.endReadParams();
        return inS.setResultFuture(obj.allocateObjectByTypeAsync(iceP_type, current), (ostr, ret) ->
            {
                ostr.writeProxy(ret);
            });
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_releaseObject(Session obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        com.zeroc.Ice.Identity iceP_id;
        iceP_id = com.zeroc.Ice.Identity.ice_read(istr);
        inS.endReadParams();
        obj.releaseObject(iceP_id, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_setAllocationTimeout(Session obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        int iceP_timeout;
        iceP_timeout = istr.readInt();
        inS.endReadParams();
        obj.setAllocationTimeout(iceP_timeout, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /** @hidden */
    final static String[] _iceOps =
    {
        "allocateObjectById",
        "allocateObjectByType",
        "destroy",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping",
        "keepAlive",
        "releaseObject",
        "setAllocationTimeout"
    };

    /** @hidden */
    @Override
    default java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return _iceD_allocateObjectById(this, in, current);
            }
            case 1:
            {
                return _iceD_allocateObjectByType(this, in, current);
            }
            case 2:
            {
                return com.zeroc.Glacier2.Session._iceD_destroy(this, in, current);
            }
            case 3:
            {
                return com.zeroc.Ice.Object._iceD_ice_id(this, in, current);
            }
            case 4:
            {
                return com.zeroc.Ice.Object._iceD_ice_ids(this, in, current);
            }
            case 5:
            {
                return com.zeroc.Ice.Object._iceD_ice_isA(this, in, current);
            }
            case 6:
            {
                return com.zeroc.Ice.Object._iceD_ice_ping(this, in, current);
            }
            case 7:
            {
                return _iceD_keepAlive(this, in, current);
            }
            case 8:
            {
                return _iceD_releaseObject(this, in, current);
            }
            case 9:
            {
                return _iceD_setAllocationTimeout(this, in, current);
            }
        }

        assert(false);
        throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
    }
}
