//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.9
//
// <auto-generated>
//
// Generated from file `Session.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceGrid;

/**
 * A session object is used by IceGrid clients to allocate and
 * release objects. Client sessions are created either via the
 * {@link Registry} object or via the registry client <code>SessionManager</code>
 * object.
 *
 * @see Registry
 **/
public interface SessionPrx extends com.zeroc.Glacier2.SessionPrx
{
    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @see Registry#getSessionTimeout
     **/
    default void keepAlive()
    {
        keepAlive(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param context The Context map to send with the invocation.
     *
     * @see Registry#getSessionTimeout
     **/
    default void keepAlive(java.util.Map<String, String> context)
    {
        _iceI_keepAliveAsync(context, true).waitForResponse();
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @return A future that will be completed when the invocation completes.
     *
     * @see Registry#getSessionTimeout
     **/
    default java.util.concurrent.CompletableFuture<Void> keepAliveAsync()
    {
        return _iceI_keepAliveAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     *
     * @see Registry#getSessionTimeout
     **/
    default java.util.concurrent.CompletableFuture<Void> keepAliveAsync(java.util.Map<String, String> context)
    {
        return _iceI_keepAliveAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_keepAliveAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "keepAlive", com.zeroc.Ice.OperationMode.Idempotent, sync, null);
        f.invoke(false, context, null, null, null);
        return f;
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * @param id The identity of the object to allocate.
     * @return The proxy of the allocated object.
     * @throws AllocationException Raised if the object can't be
     * allocated.
     * @throws ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     *
     * @see #setAllocationTimeout
     * @see #releaseObject
     **/
    default com.zeroc.Ice.ObjectPrx allocateObjectById(com.zeroc.Ice.Identity id)
        throws AllocationException,
               ObjectNotRegisteredException
    {
        return allocateObjectById(id, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * @param id The identity of the object to allocate.
     * @param context The Context map to send with the invocation.
     * @return The proxy of the allocated object.
     * @throws AllocationException Raised if the object can't be
     * allocated.
     * @throws ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     *
     * @see #setAllocationTimeout
     * @see #releaseObject
     **/
    default com.zeroc.Ice.ObjectPrx allocateObjectById(com.zeroc.Ice.Identity id, java.util.Map<String, String> context)
        throws AllocationException,
               ObjectNotRegisteredException
    {
        try
        {
            return _iceI_allocateObjectByIdAsync(id, context, true).waitForResponseOrUserEx();
        }
        catch(AllocationException ex)
        {
            throw ex;
        }
        catch(ObjectNotRegisteredException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * @param id The identity of the object to allocate.
     * @return The proxy of the allocated object.
     *
     * @see #setAllocationTimeout
     * @see #releaseObject
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> allocateObjectByIdAsync(com.zeroc.Ice.Identity id)
    {
        return _iceI_allocateObjectByIdAsync(id, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * @param id The identity of the object to allocate.
     * @param context The Context map to send with the invocation.
     * @return The proxy of the allocated object.
     *
     * @see #setAllocationTimeout
     * @see #releaseObject
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> allocateObjectByIdAsync(com.zeroc.Ice.Identity id, java.util.Map<String, String> context)
    {
        return _iceI_allocateObjectByIdAsync(id, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> _iceI_allocateObjectByIdAsync(com.zeroc.Ice.Identity iceP_id, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "allocateObjectById", null, sync, _iceE_allocateObjectById);
        f.invoke(true, context, null, ostr -> {
                     com.zeroc.Ice.Identity.ice_write(ostr, iceP_id);
                 }, istr -> {
                     com.zeroc.Ice.ObjectPrx ret;
                     ret = istr.readProxy();
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_allocateObjectById =
    {
        AllocationException.class,
        ObjectNotRegisteredException.class
    };

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * @param type The type of the object.
     * @return The proxy of the allocated object.
     * @throws AllocationException Raised if the object could not be allocated.
     *
     * @see #setAllocationTimeout
     * @see #releaseObject
     **/
    default com.zeroc.Ice.ObjectPrx allocateObjectByType(String type)
        throws AllocationException
    {
        return allocateObjectByType(type, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * @param type The type of the object.
     * @param context The Context map to send with the invocation.
     * @return The proxy of the allocated object.
     * @throws AllocationException Raised if the object could not be allocated.
     *
     * @see #setAllocationTimeout
     * @see #releaseObject
     **/
    default com.zeroc.Ice.ObjectPrx allocateObjectByType(String type, java.util.Map<String, String> context)
        throws AllocationException
    {
        try
        {
            return _iceI_allocateObjectByTypeAsync(type, context, true).waitForResponseOrUserEx();
        }
        catch(AllocationException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * @param type The type of the object.
     * @return The proxy of the allocated object.
     *
     * @see #setAllocationTimeout
     * @see #releaseObject
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> allocateObjectByTypeAsync(String type)
    {
        return _iceI_allocateObjectByTypeAsync(type, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * @param type The type of the object.
     * @param context The Context map to send with the invocation.
     * @return The proxy of the allocated object.
     *
     * @see #setAllocationTimeout
     * @see #releaseObject
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> allocateObjectByTypeAsync(String type, java.util.Map<String, String> context)
    {
        return _iceI_allocateObjectByTypeAsync(type, context, false);
    }

    /**
     * @hidden
     * @param iceP_type -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> _iceI_allocateObjectByTypeAsync(String iceP_type, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "allocateObjectByType", null, sync, _iceE_allocateObjectByType);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_type);
                 }, istr -> {
                     com.zeroc.Ice.ObjectPrx ret;
                     ret = istr.readProxy();
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_allocateObjectByType =
    {
        AllocationException.class
    };

    /**
     * Release an object that was allocated using <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code>.
     * @param id The identity of the object to release.
     * @throws AllocationException Raised if the given object can't be
     * released. This might happen if the object isn't allocatable or
     * isn't allocated by the session.
     * @throws ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     **/
    default void releaseObject(com.zeroc.Ice.Identity id)
        throws AllocationException,
               ObjectNotRegisteredException
    {
        releaseObject(id, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Release an object that was allocated using <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code>.
     * @param id The identity of the object to release.
     * @param context The Context map to send with the invocation.
     * @throws AllocationException Raised if the given object can't be
     * released. This might happen if the object isn't allocatable or
     * isn't allocated by the session.
     * @throws ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     **/
    default void releaseObject(com.zeroc.Ice.Identity id, java.util.Map<String, String> context)
        throws AllocationException,
               ObjectNotRegisteredException
    {
        try
        {
            _iceI_releaseObjectAsync(id, context, true).waitForResponseOrUserEx();
        }
        catch(AllocationException ex)
        {
            throw ex;
        }
        catch(ObjectNotRegisteredException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Release an object that was allocated using <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code>.
     * @param id The identity of the object to release.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> releaseObjectAsync(com.zeroc.Ice.Identity id)
    {
        return _iceI_releaseObjectAsync(id, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Release an object that was allocated using <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code>.
     * @param id The identity of the object to release.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> releaseObjectAsync(com.zeroc.Ice.Identity id, java.util.Map<String, String> context)
    {
        return _iceI_releaseObjectAsync(id, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_releaseObjectAsync(com.zeroc.Ice.Identity iceP_id, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "releaseObject", null, sync, _iceE_releaseObject);
        f.invoke(true, context, null, ostr -> {
                     com.zeroc.Ice.Identity.ice_write(ostr, iceP_id);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_releaseObject =
    {
        AllocationException.class,
        ObjectNotRegisteredException.class
    };

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code> will block for the duration of this
     * timeout.
     * @param timeout The timeout in milliseconds.
     **/
    default void setAllocationTimeout(int timeout)
    {
        setAllocationTimeout(timeout, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code> will block for the duration of this
     * timeout.
     * @param timeout The timeout in milliseconds.
     * @param context The Context map to send with the invocation.
     **/
    default void setAllocationTimeout(int timeout, java.util.Map<String, String> context)
    {
        _iceI_setAllocationTimeoutAsync(timeout, context, true).waitForResponse();
    }

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code> will block for the duration of this
     * timeout.
     * @param timeout The timeout in milliseconds.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> setAllocationTimeoutAsync(int timeout)
    {
        return _iceI_setAllocationTimeoutAsync(timeout, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code> will block for the duration of this
     * timeout.
     * @param timeout The timeout in milliseconds.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> setAllocationTimeoutAsync(int timeout, java.util.Map<String, String> context)
    {
        return _iceI_setAllocationTimeoutAsync(timeout, context, false);
    }

    /**
     * @hidden
     * @param iceP_timeout -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_setAllocationTimeoutAsync(int iceP_timeout, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "setAllocationTimeout", com.zeroc.Ice.OperationMode.Idempotent, sync, null);
        f.invoke(false, context, null, ostr -> {
                     ostr.writeInt(iceP_timeout);
                 }, null);
        return f;
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static SessionPrx checkedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, ice_staticId(), SessionPrx.class, _SessionPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static SessionPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, context, ice_staticId(), SessionPrx.class, _SessionPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static SessionPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, ice_staticId(), SessionPrx.class, _SessionPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static SessionPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), SessionPrx.class, _SessionPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static SessionPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, SessionPrx.class, _SessionPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static SessionPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, facet, SessionPrx.class, _SessionPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default SessionPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (SessionPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default SessionPrx ice_adapterId(String newAdapterId)
    {
        return (SessionPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default SessionPrx ice_endpoints(com.zeroc.Ice.Endpoint[] newEndpoints)
    {
        return (SessionPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default SessionPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (SessionPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default SessionPrx ice_invocationTimeout(int newTimeout)
    {
        return (SessionPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default SessionPrx ice_connectionCached(boolean newCache)
    {
        return (SessionPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default SessionPrx ice_endpointSelection(com.zeroc.Ice.EndpointSelectionType newType)
    {
        return (SessionPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default SessionPrx ice_secure(boolean b)
    {
        return (SessionPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default SessionPrx ice_encodingVersion(com.zeroc.Ice.EncodingVersion e)
    {
        return (SessionPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default SessionPrx ice_preferSecure(boolean b)
    {
        return (SessionPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default SessionPrx ice_router(com.zeroc.Ice.RouterPrx router)
    {
        return (SessionPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default SessionPrx ice_locator(com.zeroc.Ice.LocatorPrx locator)
    {
        return (SessionPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default SessionPrx ice_collocationOptimized(boolean b)
    {
        return (SessionPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default SessionPrx ice_twoway()
    {
        return (SessionPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default SessionPrx ice_oneway()
    {
        return (SessionPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default SessionPrx ice_batchOneway()
    {
        return (SessionPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default SessionPrx ice_datagram()
    {
        return (SessionPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default SessionPrx ice_batchDatagram()
    {
        return (SessionPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default SessionPrx ice_compress(boolean co)
    {
        return (SessionPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default SessionPrx ice_timeout(int t)
    {
        return (SessionPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default SessionPrx ice_connectionId(String connectionId)
    {
        return (SessionPrx)_ice_connectionId(connectionId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except it's a fixed proxy bound
     * the given connection.@param connection The fixed proxy connection.
     * @return A fixed proxy bound to the given connection.
     **/
    @Override
    default SessionPrx ice_fixed(com.zeroc.Ice.Connection connection)
    {
        return (SessionPrx)_ice_fixed(connection);
    }

    static String ice_staticId()
    {
        return "::IceGrid::Session";
    }
}
